<?php defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';
class ClaimController extends REST_Controller {

    public $user_id = null;

    private $Services = [
        'task/TaskService'                      => 'TaskService',
        'task/JobsheetService'                  => 'JobsheetService',
        'task/JobsheetService'                  => 'JobsheetService',
        'SettingService'                        => 'SettingService',
        'task/ClaimService'                     => 'ClaimService',
    ];

    function __construct() {
        parent::__construct();
        $this->load->service($this->Services);
    }

	/* START :: MAIN */
		public function all_get($user_id=null){
            $this->user_id  = $user_id;
            $voucher        = $this->_claim_component();
			$this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'voucher' => $voucher,
                'status' => !empty($voucher) ? true : false,
            ], REST_Controller::HTTP_OK);
		}

		private function _claim_component(){
            $vouchers = $this->DatabaseModel->readArrayWithOptionsOrderBy(['user_id' => $this->user_id
            ], self::$field->ClaimVoucher, 'created_date DESC', self::$tbl->ClaimVoucher);

            if(!empty($vouchers)){
                foreach ($vouchers as $k => $val) {
                    $vouchers[$k]['claim'] = $this->ClaimService->_claim_listing($val['voucher_no']);
                    $vouchers[$k]['status_label'] = ClaimService::STAT[$val['status']];
                    $vouchers[$k]['voucher_title'] = 'VOUCHER NO: '.$val['voucher_no'];
                    $vouchers[$k]['total_claim_title'] = 'TOTAL CLAIM AMOUNT: '.CURRENCY.' '.$val['total_claim'];
                    $vouchers[$k]['total_claimable_title'] = 'TOTAL CLAIMABLE: '.CURRENCY.' '.$val['total_claimable'];
                }
            }
            return $vouchers;
		}

		private function _calculate_days($receipt_date, $created_date){
			$date1 = date_create(dbDateFormat($receipt_date));
			$date2 = date_create(dbDateFormat($created_date));

			$diff  = date_diff($date1,$date2);
			return $diff->d;
		}

    /* START :: VIEW */
        public function voucher_claim_get($voucher_no=null){
            $voucherArr = [];
            $voucher        = $this->ClaimService->_voucher_detail($voucher_no);
            if(!empty($voucher)){
                $voucher['claim'] = $this->ClaimService->_claim_listing($voucher['voucher_no']);
                if(!empty($voucher['claim'])){
                    foreach($voucher['claim'] as $k => $val){
                        $voucher['claim'][$k]['claim_amt_label'] = CURRENCY.$val['claim_amt'];
                        $voucher['claim'][$k]['claimable'] = ($val['can_claim'] == 1) ? 'Yes' : ($val['can_claim'] == 2 ? 'No' : '');
                    }
                }

                $voucher['status_label'] = ClaimService::STAT[$voucher['status']];
                $voucher['voucher_title'] = 'VOUCHER NO: '.$voucher['voucher_no'];
                $voucher['total_claim_title'] = 'TOTAL CLAIM AMOUNT: '.CURRENCY.' '.$voucher['total_claim'];
                $voucher['total_claimable_title'] = 'TOTAL CLAIMABLE: '.CURRENCY.' '.$voucher['total_claimable'];
            }
            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'voucher' => $voucher,
                'status' => !empty($voucher) ? true : false,
            ], REST_Controller::HTTP_OK);
        }

    	private function _claim_detail_component($pc_no){
    		$claimDetail = $this->DatabaseModel->readOneWithOptions(['pc_no' => $pc_no], self::$field->Claim, self::$tbl->Claim);
            if(!empty($claimDetail)){
            	$claimDetail['days'] 	   = $this->_calculate_days($claimDetail['receipt_date'], $claimDetail['created_date']);
                $claimDetail['by']         = $this->UserService->_employee_detail($claimDetail['user_id']);
                $claimDetail['co_receipt'] = $this->ClaimService->_claim_attc($claimDetail['pc_no']);
                $claimDetail['linked_cust']= $this->ClaimService->_claim_linked_customer_listing($claimDetail['id']);
                $claimDetail['task']       = $this->TaskService->_simple_task_detail($claimDetail['task_id']);
                $claimDetail['project']    = $this->SettingService->_project_detail($claimDetail['project_id']);
                $claimDetail['category']   = $this->ClaimService->_claim_category_detail($claimDetail['claimcategory_id']);
                $claimDetail['cust']       = $this->ClaimService->_claim_linked_customer_listing($claimDetail['pc_no']);
                $claimDetail['acc']        = $this->ClaimService->_claim_account_detail($claimDetail['claimaccount_id']);
                $claimDetail['company']    = $this->SettingService->_company_on_receipt_detail($claimDetail['claimcompany_id']);
            }
            return $claimDetail;
    	}

        public function inline_view($pc_no=null){
			$voucher     = $this->_claim_component();
			$claimDetail = $this->_claim_detail_component($pc_no);

            if(isset($_POST['delete'])){
                $claim_id = $this->input->post('delete');
                $this->DatabaseModel->deleteData(['id' => $claim_id], self::$tbl->Claim);
                redirect(self::$prefix_url);
            }

			$this->data['voucher']    	= isset($voucher) ? $voucher : [];
			$this->data['claimDetail']  = isset($claimDetail) ? $claimDetail : [];
            $this->data['back_url'] 	= self::$prefix_url;
            $this->load->views([
                self::$root_file.'inline-view.tpl.php',
                //self::$root_file.'js-script.tpl.php'
            ], $this->data);
		}

        public function details_get($pc_no=null){
        	$mode  		 = $this->input->get('mode');
            $claimDetail = $this->_claim_detail_component($pc_no);

            if(!empty($claimDetail)){
                $claimDetail['claimable'] = $claimDetail['can_claim'] ? 'Yes' : ($claimDetail['can_claim'] == 2 ? 'No' : '');
                $claimDetail['receipt_no'] = !empty($claimDetail['receipt_no']) ? $claimDetail['receipt_no'] : 0;
                $claimDetail['claim_amt_label'] = CURRENCY.$claimDetail['claim_amt'];
                $claimDetail['toll_in_out'] = !empty($claimDetail['toll_in']) && !empty($claimDetail['toll_out']) ? $claimDetail['toll_in'].' - '.$claimDetail['toll_out'] : '';
            }

            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'claimDetail' => $claimDetail,
                'status' => !empty($claimDetail) ? true : false,
            ], REST_Controller::HTTP_OK);

            // $this->data['claimDetail']  = isset($claimDetail) ? $claimDetail : [];
            // $this->data['back_url'] 	= $mode && $mode === 'table' ? self::$prefix_url.'?mode=table' : self::$prefix_url;
            // $this->load->views([
            //     self::$root_file.'view.tpl.php',
            //     //self::$root_file.'js-script.tpl.php'
            // ], $this->data);
        }

    /* START :: DELETE */
        public function delete_voucher_get($voucher_no=null){
            $this->DatabaseModel->deleteData(['voucher_no' => $voucher_no], self::$tbl->ClaimVoucher);
            $claim = $this->DatabaseModel->readArrayWithOptions(['voucher_no' => $voucher_no], self::$field->Claim, self::$tbl->Claim);
            if(!empty($claim)){
                foreach ($claim as $val) {
                    $this->delete_receipt_related($val['pc_no']);
                }
            }
            $this->DatabaseModel->deleteData(['voucher_no' => $voucher_no], self::$tbl->Claim);
            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => true,
            ], REST_Controller::HTTP_OK);
        }

        public function delete_receipt_get($pc_no=null){
            $this->DatabaseModel->deleteData(['pc_no' => $pc_no], self::$tbl->Claim);
            $this->delete_receipt_related($pc_no);
            // $this->ClaimService->_update_claim_total($claim['voucher_no'], $claim['claim_amt'], 'delete');
            
            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => true,
            ], REST_Controller::HTTP_OK);
        }

        private function delete_receipt_related($pc_no){
            $this->DatabaseModel->deleteData(['pc_no' => $pc_no], self::$tbl->ClaimAttc);
            $this->DatabaseModel->deleteData(['pc_no' => $pc_no], self::$tbl->ClaimLinkedCust);
        }

    /* START :: AJAX SUBMISSION */
    	public function ajax_view_receipt($pc_no=null){
			$claimDetail                = $this->_claim_detail_component($pc_no);
            if(!empty($claimDetail)){
                $claimDetail['voucher'] = $this->ClaimService->_voucher_detail($claimDetail['voucher_no']);
            }
            //print_array($claimDetail); exit();
			$this->data['claimDetail']  = isset($claimDetail) ? $claimDetail : [];
    		$this->load->view(self::$root_file.'/_component/claim-detail.tpl.php', $this->data);
    	}

        public function ajax_get_claim_attc($pc_no=null){
            $claimDetail                = $this->_claim_detail_component($pc_no);
            if(!empty($claimDetail)){
                $claimDetail['voucher'] = $this->ClaimService->_voucher_detail($claimDetail['voucher_no']);
            }
            $this->data['claimDetail']  = isset($claimDetail) ? $claimDetail : [];
            $this->load->view(self::$root_file.'/_component/claim-attc.tpl.php', $this->data);
        }

        public function ajax_delete_receipt($pc_no=null){
            $this->DatabaseModel->deleteData(['pc_no' => $pc_no], self::$tbl->Claim);
        }

        public function ajax_get_account($claimcategory_id=null){
            $acc = $this->SettingService->_claim_acc_by_cat_dep($claimcategory_id, $this->department_id);
            if(!empty($acc)){
                echo json_encode([
                    'id'   => $acc['id'],
                    'code' => $acc['code']
                ]);
            } else {
                echo json_encode([
                    'id'   => '',
                    'code' => ''
                ]);
            }
        }

        public function ajax_get_category_detail($claimcategory_id=null){
            $category = $this->ClaimService->_claim_category_detail($claimcategory_id);
            echo !empty($category['remark']) ? '<div class="padding-top10">'.nl2br($category['remark']).'</div>' : null;
        }

        public function ajax_get_spc_calculation(){
            $km  = $this->input->get('km') ? $this->input->get('km') : 0;
            $spc = $this->ClaimService->_calculate_spc($km);
            echo $spc;
        }

    /* START :: SUBMIT */
        public function submit_claim_get($voucher_no=null){
            $this->DatabaseModel->updateData(['voucher_no' => $voucher_no], [
                'status' => ClaimService::_STAT_SUBMITTED
            ], self::$tbl->ClaimVoucher);

            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => true,
            ], REST_Controller::HTTP_OK);
        }

        public function create_voucher_post($user_id=null){
            $data = json_decode(file_get_contents('php://input'), true);
            $this->user_id = $user_id;
            $voucher_no  = $this->ClaimService->_generate_voucher_no();
            $voucherData = [
                'voucher_no'    => $voucher_no,
                'user_id'       => $this->user_id,
                'voucher_date'  => currentDate(),
                'created_date'  => currentTimeStamp(),
                'voucher_remark' => !empty($data) && isset($data['voucher_remark']) ? $data['voucher_remark'] : ''
            ];

            $this->DatabaseModel->createData($voucherData, self::$tbl->ClaimVoucher);
            $voucher = $this->ClaimService->_voucher_detail($voucher_no);
            if(!empty($voucher)){
                $voucher['claim'] = $this->ClaimService->_claim_listing($voucher['voucher_no']);
                $voucher['status_label'] = ClaimService::STAT[$voucher['status']];
                $voucher['voucher_title'] = 'VOUCHER NO: '.$voucher['voucher_no'];
                $voucher['total_claim_title'] = 'TOTAL CLAIM AMOUNT: '.CURRENCY.' '.$voucher['total_claim'];
                $voucher['total_claimable_title'] = 'TOTAL CLAIMABLE: '.CURRENCY.' '.$voucher['total_claimable'];
            }
            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'voucher' => $voucher,
                'status' => !empty($voucher) ? true : false,
            ], REST_Controller::HTTP_OK);
        }

        # create claim receipt
        public function create($voucher_no=null){
            $AssignedTask = $this->TaskService->_all_assigned_task($this->user_id);
            $cust         = $this->UserService->_customer_listing();
            $cat          = $this->ClaimService->_claim_cat_listing();
            $project      = $this->SettingService->_all_project();
            $refPcNo      = $this->input->get('ref');
            $claimArr     = $this->ClaimService->_claim_listing($voucher_no);
            $voucher      = $this->ClaimService->_voucher_detail($voucher_no);
            $companyArr   = $this->SettingService->_claim_company_listing();
            $department   = self::$conf_dep;
            $pay          = $this->DatabaseModel->readOneWithOptions(['voucher_no' => $voucher_no], self::$field->ClaimPayment, self::$tbl->ClaimPayment);

            if(!empty($cat)){
                $acc = $this->SettingService->_claim_acc_by_cat_dep($cat[0]['id'], $this->department_id);
            }

            if(!empty($claimArr)){
                $total_claim = 0;
                foreach ($claimArr as $k => $val) {
                    $claimListing[$k] = $val;
                    $claimListing[$k]['edit_url'] = current_url().'?mode=edit&ref='.$val['pc_no'];

                    if($val['can_claim'] == 1){
                        $total_claim = $val['claim_amt'] + $total_claim;
                    }
                }
            }

            if($refPcNo){
                $currentClaim = $this->ClaimService->_claim_by_pc_no($refPcNo);
                if(!empty($currentClaim)){
                    $linkedCustIDs = array_column($currentClaim['linked_cust'], 'cust_id');
                }
                $custIDs = [];
                if(!empty($cust)){
                    foreach ($cust as $k => $val) {
                        if(!empty($linkedCustIDs)){
                            if(in_array($val['user_id'], $linkedCustIDs)){
                                unset($cust[$k]);
                            }
                        }
                    }
                }
            }

            if(isset($_POST['create_pre_receipt'])){
                $pc_no       = $this->ClaimService->_generate_pc_no();
                $receiptData = [
                    'user_id'       => $this->user_id,
                    'department_id' => $this->department_id,
                    'claim_source'  => 'general',
                    'voucher_no'    => $voucher_no,
                    'pc_no'         => $pc_no,
                    'created_date'  => currentTimeStamp()
                ];
                $this->DatabaseModel->createData($receiptData, self::$tbl->Claim);
                redirect(current_url().'?ref='.$pc_no);
            }

            if(isset($_POST['save_receipt'])){
                $this->_update_receipt($this->input->post('pc_no'));
            }

            if(isset($_POST['update_receipt'])){
                $this->_update_receipt($this->input->post('pc_no'));
            }

            if(isset($_POST['delete_claim'])){
                $claim_id = $this->input->post('delete_claim');
                $claim    = $this->DatabaseModel->readOneWithOptions(['id' => $claim_id], self::$field->Claim, self::$tbl->Claim);

                if(!empty($claim)){
                    $this->ClaimService->_update_claim_total($claim['voucher_no'], $claim['claim_amt'], 'delete');
                }

                $this->DatabaseModel->deleteData(['id' => $claim_id], self::$tbl->Claim);
                // $this->session->set_flashdata('success_msg', deleteMsg());

                redirect(current_url());
            }

            $this->data['claimListing']     = isset($claimListing) ? $claimListing : [];
            $this->data['claimData']        = isset($currentClaim) ? $currentClaim : [];
            $this->data['voucher']          = $voucher;
            $this->data['assigned']         = $AssignedTask;
            $this->data['cust']             = $cust;
            $this->data['cat']              = $cat;
            $this->data['project']          = $project;
            $this->data['company']          = $companyArr;
            $this->data['department']       = $department;
            $this->data['acc']              = isset($acc) ? $acc : [];
            $this->data['total_claim']      = isset($total_claim) ? $total_claim : 0;
            $this->data['pay']              = $pay;
            $this->data['back_url']         = self::$prefix_url;
            $this->data['receipt_del_url']  = self::$prefix_url.'/delete-receipt';
            $this->data['cust_del_url']     = self::$prefix_url.'/delete-customer';
            $this->data['ajax_url']         = self::$prefix_url.'/ajax-';
            $this->pageMainTitle            = 'Submit Claim';
            $this->load->views([
                self::$root_file.'create-claim-receipt.tpl.php',
                //self::$root_file.'js-script.tpl.php'
            ], $this->data);
        }

        public function delete_receipt(){
            $attc_id = $this->input->get('attc_id');
            if($attc_id){
                $this->DatabaseModel->deleteData(['id' => $attc_id], self::$tbl->ClaimAttc);
            }
        }

        public function delete_customer(){
            $linked_cust_id = $this->input->get('linked_cust_id');
            if($linked_cust_id){
                $this->DatabaseModel->deleteData(['id' => $linked_cust_id], self::$tbl->ClaimLinkedCust);
            }
        }

        private function _update_receipt($pc_no){
            $claim           = $this->ClaimService->_claim_detail($pc_no);
            $voucher_no      = !empty($claim) ? $claim['voucher_no'] : 0;
            $_linked_cust_id = $this->input->post('linked_cust_id');
            $receipt_amt     = $this->input->post('receipt_amt');
            $claim_amt       = $this->input->post('claim_amt');

            $claimData       = [
                'claimcompany_id'       => $this->input->post('claimcompany_id'),
                'company_receipt_name'  => $this->input->post('company_receipt_name') ? $this->input->post('company_receipt_name') : '',
                'receipt_date'          => dbDateFormat($this->input->post('receipt_date')),
                'receipt_no'            => $this->input->post('receipt_no'),
                'receipt_amt'           => $receipt_amt,
                'claim_amt'             => $claim_amt,
                'toll_in'               => $this->input->post('toll_in'),
                'toll_out'              => $this->input->post('toll_out'),
                'claimcategory_id'      => $this->input->post('claimcategory_id'),
                'claimaccount_id'       => $this->input->post('claimaccount_id'),
                'project_id'            => $this->input->post('project_id'),
                'remarks'               => $this->input->post('remarks'),
                'spc'                   => $this->input->post('km') ? $this->input->post('km') : 0,
            ];

            $this->DatabaseModel->updateData(['pc_no' => $pc_no], $claimData, self::$tbl->Claim);
            $this->ClaimService->_update_claim_total($voucher_no, $claim_amt, 'add');

            if(!empty($_linked_cust_id)){
                $linkedCustData = [];
                foreach ($_linked_cust_id as $k => $val) {
                    $linkedCustData[$k] = [
                        'pc_no'    => $pc_no,
                        'cust_id'  => $val
                    ];
                }
                $this->DatabaseModel->createMultiData($linkedCustData, self::$tbl->ClaimLinkedCust);
            }

            # refer to the receipt to claim
            if(!empty($_FILES['company_receipt']['name'][0])){
                $coReceiptArr = $this->MediaService->_upload_multi_images(UPLOAD_PATH.'/receipt', $_FILES['company_receipt'], 'company_receipt');
                if(!empty($coReceiptArr)){
                    $receiptData = [];

                    foreach ($coReceiptArr as $k => $row) {
                        $receiptData[$k] = [
                            'pc_no'     => $pc_no,
                            'attc_type' => ClaimService::_CLAIM_CO_RECEIPT,
                            'file_src'  => $row['file_name']
                        ];
                    }

                    $this->DatabaseModel->createMultiData($receiptData, self::$tbl->ClaimAttc);
                }
            }
            redirect(current_url());
        }
}