<?php defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';
class NotificationsController extends REST_Controller {
	public $pageMainTitle       = 'Notifications';
    private static $prefix_url  = 'notifications';

    function __construct() {
        parent::__construct();
        self::$prefix_url          = base_url(self::$prefix_url);
    }

    public function index_get(){
        $user_id    = $this->input->get('user_id') ? $this->input->get('user_id') : null;

        $sql = 'SELECT COUNT(NotificationsReceiver.id) AS total
            FROM NotificationsReceiver
            LEFT JOIN Notifications ON Notifications.id = NotificationsReceiver.notify_id
            WHERE NotificationsReceiver.receiver_id = '.$user_id.' 
            AND NotificationsReceiver.is_seen = 0';
        $unread = $this->DatabaseModel->readOneQuery($sql);
        
        $this->response([
            'http_status_code' => REST_Controller::HTTP_OK,
            'status' => $user_id !== 'undefined' ? true : false,
            'notifications' => [
                'unread' => !empty($unread) ? $unread['total'] : 0
            ]
        ]);
    }

    public function mark_read_get($notifyID=null){
        $this->DatabaseModel->updateData(['id' => $notifyID], [
            'is_seen' => true
        ], 'NotificationsReceiver');
        
        $this->response([
            'http_status_code' => REST_Controller::HTTP_OK,
            'status' => true,
        ]);
    }

    public function mark_all_read_get($user_id=null){
        $this->DatabaseModel->updateData(['receiver_id' => $user_id, 'receiver_type' => 'user'], [
            'is_seen' => 1
        ], 'NotificationsReceiver');

        $this->response([
            'http_status_code' => REST_Controller::HTTP_OK,
            'status' => true,
        ]);
    }

    public function fetch_more_get(){
        $user_id    = $this->input->get('user_id') ? $this->input->get('user_id') : null;
        $nextOffset = $this->input->get('nextOffset');
        $offset     = 0;

        # if have offset, it came from fetch more function
        # else, it came from the initial fetch
        $offset  = $nextOffset ? $nextOffset : $offset;

        $sql = 'SELECT 
                NotificationsReceiver.*,
                Notifications.content,
                Notifications.created_date AS notify_created_date,
                Notifications.ref_id,
                Notifications.ref_code
            FROM NotificationsReceiver
            LEFT JOIN Notifications ON Notifications.id = NotificationsReceiver.notify_id
            WHERE NotificationsReceiver.receiver_id = '.$user_id.'
            ORDER BY Notifications.created_date DESC
            LIMIT '.$offset.', 20';
        $notifications = $this->DatabaseModel->readArrayQuery($sql);

        if(!empty($notifications)){
            foreach($notifications as $k => $row){
                $notifications[$k]['notify_created_date'] = sysDateTimeFormat($row['notify_created_date']);
            }
        }
        
        $this->response([
            'http_status_code' => REST_Controller::HTTP_OK,
            'status' => $user_id !== 'undefined' ? true : false,
            'data' => [
                'notifications' => $notifications,
                'offset' => $offset + 20, # set for the next offset fetch
            ]
        ]);
    }

}