<?php defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';
class TaskController extends REST_Controller {

    public $user_id = null;
    public $company_id = null;
    public $user_access = [];

    private $Services = [
        'task/TaskService'                      => 'TaskService',
        'operation/task/OP_TaskService'         => 'OP_TaskService',
        'task/JobsheetService' 					=> 'JobsheetService',
        'task/TaskMainService'                  => 'TaskMainService'
    ];

	function __construct() {
		parent::__construct();
		$this->load->service($this->Services);
        $this->user_access = [];
	}

	/* START :: MAIN */
		public function all_get($user_id=null){
            $this->user_id  = $user_id;
            $this->user_access = $this->AccessService->_user_access($user_id);
            $next      = $this->input->get('next') ? $this->input->get('next') : 50;
            $orderBy   = $this->input->get('orderBy') ? $this->input->get('orderBy') : 'DESC';
            $start     = $next - 50;
            $limit     = $next;

            $lastTaskId = $this->input->get('lastTaskId') ? $this->input->get('lastTaskId') : null;
            $task           = [];
            $last_task_id   = $this->input->get('last_task_id') && $this->input->get('last_task_id') !== 'undefined' ? $this->input->get('last_task_id') : null;
            $nextOffset = $this->input->get('nextOffset');
            $offset     = 0;
            $offset     = $nextOffset ? $nextOffset : $offset;

			$user      = $this->UserService->_user_detail($user_id);
            $role_id   = !empty($user) ? $user['role_id'] : null;
            $task_type = $this->input->get('type') ? $this->input->get('type') : 'mypending';
            $operator  = $this->OP_TaskService->getOperator($task_type);
            $this->company_id = $user['company_id'];

            $userCompanyCodename    = $this->DatabaseModel->readOneWithOptions(['ref' => 'company', 'ref_id' => $this->company_id], '*', 'CompanyCodeName');
            $userCompanyCodenameID  = !empty($userCompanyCodename) ? $userCompanyCodename['id'] : null;
            $whereConnector = ' AND';

            if($task_type === 'mypending'){
                # only own pending task
                $sql = 'SELECT DISTINCT Task.* FROM Task
                        LEFT JOIN TaskAssigned ON TaskAssigned.task_id = Task.id
                        WHERE (TaskAssigned.user_id = '.$this->user_id.')';
            } else {
                # should include self created task
                if(!$this->user_access['TSK029']){
                    if($this->user_access['TSK028']){
                        # only own task
                        $sql = 'SELECT DISTINCT Task.* FROM Task
                                LEFT JOIN TaskAssigned ON TaskAssigned.task_id = Task.id
                                WHERE (TaskAssigned.user_id = '.$this->user_id.' OR Task.createdby_id = '.$this->user_id.')';
                    }
                    if($this->user_access['TSK032']){
                        # only own company task (all)
                        # where the customer company name is same as the registered company as the logged user
                        # we won't specify task assigned to this current user because this access code is to display all task regardless who get assigned to
                        $sql = 'SELECT DISTINCT Task.* FROM Task
                                WHERE (Task.codename_id = '.$userCompanyCodenameID.'
                                OR Task.createdby_id = '.$this->user_id.')';
                    }
                    if($this->user_access['TSK033']){
                        # only own company task (individual)
                        # same as TSK032 but this is for task assigned to single user only
                        $sql = 'SELECT DISTINCT Task.* FROM Task
                                LEFT JOIN TaskAssigned ON TaskAssigned.task_id = Task.id
                                WHERE Task.codename_id = '.$userCompanyCodenameID.'
                                AND (TaskAssigned.user_id = '.$this->user_id.' OR Task.createdby_id = '.$this->user_id.')';
                        // $task = $this->TaskMainService->_only_own_company_task_individual($task, $this->user_id, $this->company_id);
                    }
                } else {
                    $sql = 'SELECT DISTINCT Task.* FROM Task';
                    $whereConnector = ' WHERE';
                }
            }

            $totalFound = 0;
            if(!empty($sql)){
                if(($task_type === 'mypending') || ($task_type === 'teampending')){
                    # get all current user pending task regardless the date
                    $sql .= $whereConnector.' Task.status = '.TaskService::_OPEN;
                    if(!empty($lastTaskId)){
                        $sql .= ' AND Task.id < '.$lastTaskId;
                    }
                    $totalFound = $this->DatabaseModel->readArrayQuery($sql);
                    $sql .= ' ORDER BY Task.planned_date '.$orderBy.' LIMIT '.$start.', 50';
                } else if($task_type === 'todayscompleted') {
                    # get all current user pending task regardless the date
                    $sql .= $whereConnector.' Task.status = '.TaskService::_COMPLETED.' AND DATE(Task.completed_date) = CURDATE()';
                    if(!empty($lastTaskId)){
                        $sql .= ' AND Task.id < '.$lastTaskId;
                    }
                    $totalFound = $this->DatabaseModel->readArrayQuery($sql);
                    $sql .= ' ORDER BY Task.completed_date '.$orderBy.' LIMIT '.$start.', 50';
                } else if($task_type === 'closed'){
                    $sql .= $whereConnector.' Task.status = '.TaskService::_CLOSED;
                    if(!empty($lastTaskId)){
                        $sql .= ' AND Task.id < '.$lastTaskId;
                    }
                    $sql .= ' ORDER BY Task.planned_date DESC LIMIT '.$start.', 50';
                } else {
                    $sql .= $whereConnector.' Task.status != '.TaskService::_CLOSED;
                    $sql .= ' AND Task.planned_date '.$operator.' "'.date('Y-m-d', strtotime(getDateToday())).'"';
                    if(!empty($lastTaskId)){
                        $sql .= ' AND Task.id < '.$lastTaskId;
                    }
                    $sql .= ' ORDER BY Task.planned_date DESC LIMIT '.$start.', 50';
                }

                $tasks = $this->DatabaseModel->readArrayQuery($sql);
                $pages = $this->PaginationService->_get_special_pagination($start, $limit, $sql, 'Task');

                if(!empty($tasks)){
                    $task      = $this->TaskService->_task_full_details($tasks);
                    foreach ($task as $k => $val) {
                        $attndDuration = minsToHours($val['task_minutes_duration']);
                        // $task[$k]['attnd_hours'] = $attndDuration['hours'].' H '.$attndDuration['min'].' M';
                        $task[$k]['attnd_hours'] = round($val['task_minutes_duration']/60, 2).' H';
                        $task[$k]['status_label'] = TaskService::_STATUS[$val['status']];
                        $task[$k]['status_color'] = TaskService::_STATUS_COLOR[$val['status']];
                    }
                }
            }

            if(!empty($task)){
            	$this->response([
                    'http_status_code' => REST_Controller::HTTP_OK,
                    'status' 	=> true,
                    'task'      => $task,
                    'rows'      => count($task),
                    'pages'     => $pages,
                    'totalFound' => !empty($totalFound) ? count($totalFound) : 0
                ], REST_Controller::HTTP_OK);
            } else {
                //$this->bad_request();
                $this->response([
                    'http_status_code' => REST_Controller::HTTP_OK,
                    'status' => false,
                ], REST_Controller::HTTP_OK);
            }
		}

		private function _sub_task_type($taskcategory_id, $task_subcategory_id){
			$sub_task = '';
			$sub_cat  = [];
			if($taskcategory_id == TaskService::_TASK_SMARTER){
				$sub_cat = $this->DatabaseModel->readOneWithOptions(['id' => $task_subcategory_id], 'title', 'TaskSubCategories');
			}
			return isset($sub_cat['title']) ? $sub_cat['title'] : '';
		}

		private function getAssignedName($assigned){
			$emp = '';
			if(!empty($assigned)){
				foreach ($assigned as $k => $row) {
					$emp .= $row['employee']['code_name'];
					$emp .= $k == (count($assigned)-1) ? '' : ', ';
				}
			}
			return $emp;
		}

        public function handle_get($task_id=null){
            $action  = $this->input->get('action') ? $this->input->get('action') : null;
            $user_id = $this->input->get('user_id') ? $this->input->get('user_id') : null;
            if($action === 'complete'){
                $this->_update_task_status($task_id, TaskService::_COMPLETED, $user_id);
            }

            if($action === 'reopen'){
                $this->_update_task_status($task_id, TaskService::_INPROGRESS, $user_id);
            }

            if($action === 'close'){
                $this->_update_task_status($task_id, TaskService::_CLOSED, $user_id);
            }

            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => true,
            ], REST_Controller::HTTP_OK);
        }

        private function _update_task_status($task_id, $status_type, $user_id){
            $this->profile   = $this->UserService->_employee_detail($user_id);

        	$taskData = [
                'modifiedby_id' => $user_id,
                'modified_date' => getCurrentTimeStamp(),
                'status'        => $status_type
            ];

            if($status_type === TaskService::_INPROGRESS){
            	// if in progress, reset the duration and completed date. Need to do for open also.
        		$taskData['duration'] 		= 0;
        		$taskData['completed_date'] = '0000-00-00 00:00:00';
        		$taskData['task_minutes_duration'] = 0;
        	}

        	if($status_type === TaskService::_COMPLETED){
        		$completed_date = getCurrentTimeStamp();
        		$task 			= $this->DatabaseModel->readOneWithOptions(['id' => $task_id], 'created_date', self::$tbl->Task);
				$duration 		= getDays($task['created_date'], $completed_date);
				$taskAttnd 		= $this->DatabaseModel->readArrayWithOptions(['task_id' => $task_id], 'check_in, check_out', self::$tbl->TaskAttnd);

				$durationInMins = 0;
				if(!empty($taskAttnd)){
					foreach ($taskAttnd as $k => $val) {
						$mins = hoursToMins($val['check_in'], $val['check_out']);

						$durationInMins = $durationInMins + $mins;
					}
				}

        		$taskData['duration'] 		= $duration;
        		$taskData['completed_date'] = $completed_date;
        		$taskData['task_minutes_duration'] = $durationInMins;
        	}

            $this->DatabaseModel->updateData(['id' => $task_id], $taskData, $this->TableService->Task);

            $taskDetails = $this->DatabaseModel->readOneQuery('SELECT ticket_id, codename_id FROM Task WHERE Task.id = '.$task_id);
            $this->NotificationsService->_notify_task_status_updated(
                $task_id, 
                $taskDetails['ticket_id'], 
                $this->profile['code_name'], 
                $taskDetails['codename_id'], 
                TaskService::_STATUS[$status_type]
            );

            $emailData = $this->TaskService->_get_task_data_for_email($task_id, $user_id);
            $emailData['msg'] = notify_taskStatusUpdate($emailData['ticket_no'], TaskService::_STATUS[$status_type]);
            $codenameDetails = $this->UserService->_codename_by_id($taskDetails['codename_id']);
            if(!empty($codenameDetails)){
                if(isset($codenameDetails['company']) && !empty($codenameDetails['company']['email'])){
                    // $this->notifyEmail($emailData, [
                    //     'to_email' => $codenameDetails['company']['email'],
                    //     'to_name'  => $codenameDetails['company']['company_name']
                    // ]);
                }
            }
        }

    /* START :: VIEW */
        public function detail_get($task_id=null){
            $user_id = $this->input->get('user_id') ? $this->input->get('user_id') : null;
            $task    = [];

            $sql    = 'SELECT '.$this->TableFieldService->Task.' FROM '.$this->TableService->Task.' WHERE id = '.$task_id;
            $task  = $this->DatabaseModel->readOneQuery($sql);
            $task 	 = $this->TaskService->_task_single_full_details($task);
            
            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status'    => !empty($task) ? true : false,
                'task'      => $task
            ], REST_Controller::HTTP_OK);
        }

        public function delete_get($task_id){
        	$this->OP_TaskDeleteService->deleteTask($task_id);
        	$this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => true,
                'task_id' => $task_id
            ], REST_Controller::HTTP_OK);
        }

    /* START :: CREATE */
        public function create_get(){
            $user_id    = $this->input->get('user_id') ? $this->input->get('user_id') : null;
            $this->user_access = $this->AccessService->_user_access($user_id);
            $users      = [];
            $cats       = $this->DatabaseModel->readArray(self::$field->TaskCat, self::$tbl->TaskCat);
            $sub_cats   = $this->DatabaseModel->readArrayWithOptions(['taskcategory_id' => TaskService::_TASK_SMARTER], self::$field->TaskSubCat, self::$tbl->TaskSubCat);
            $company    = $this->UserService->_all_company_code_name();
            $group      = $this->AccessService->_all_access_group();
            $department = $this->SettingService->_all_department();

            if($user_id != 1){
                if(!$this->user_access['TSK007']){
                    if($this->user_access['TSK039']){
                        $company_id = $this->profile['user']['company_id'];
                        $users      = $this->UserService->_user_by_company($company_id);
                        $company    = $this->UserService->_user_company_only($company, $company_id);
                    } else {
                        if(!empty($this->department_id)){
                            if($this->user_access['TSK004'] || $this->user_access['TSK005'] || $this->user_access['TSK006']){
                                $department = $this->AccessService->_only_user_department($department, $this->department_id);
                            }
                        }
                    }
                }
            }

            if(!empty($cats)){
                # 1 = Customer task
                # 2 = Smarter task
                foreach ($cats as $k => $val) {
                    if($val['id'] == 1 && !$this->user_access['TSK001']){
                        unset($cats[$k]);
                    }
                    if($val['id'] == 2 && !$this->user_access['TSK002']){
                        unset($cats[$k]);
                    }
                }
            }

            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => true,
                'cats'     => $cats,
                'sub_cats' => $sub_cats,
                'company'  => $company,
                'team'     => $group,
                'dept'     => $department,
                'users'    => $users,
            ]);
        }

        # this function is just for email testing
        public function loadEmail_get(){
            $this->load->library('email');

            $data = [
                'ticket_no'     => '02571',
                'company_name'  => 'company',
                'title'         => 'pc need to change',
                'description'   => 'pc need to change',
                'planned_date'  => '15 Aug 2021',
                'assigned'      => 'PTR, 6FR',
                'img_url'       => base_url('assets/images/icons/task-icon.png'),
                'msg'           => 'task created for test',
                'created_by'    => 'PTR'
            ];

            $message = $this->load->view('email/new-task.email.php', $data, true);

            $this->email->initialize(sendgridConfig());
            $this->email->from('noreply@smarter.com.my', 'SSMS Automail');
            $this->email->to('testing.mael@gmail.com', 'MACALLUM BR20');
            // $this->email->cc($cc['email'], $cc['fullname']);

            // echo $message; exit();

            $this->email->subject('NEW TASK #02571');
            $this->email->message($message);
            // exit($message);
            $this->email->send();
            // mail("testing.mael@gmail.com","NEW TASK #02571",$message);
        }

        private function notifyEmail($emailData=null, $toData=null){
            if(!empty($emailData)){
                $this->load->library('email');

                $message = $this->load->view('email/new-task.email.php', $emailData, true);

                $this->email->initialize(sendgridConfig());
                $this->email->from('noreply@smarter.com.my', 'SSMS Automail');

                if(MODE === 'PRODUCTION' || MODE === 'TEST'){
                    $this->email->to($toData['to_email'], $toData['to_name']);
                } else {
                    $this->email->to('testing.mael@gmail.com', $toData['to_name']);
                }

                if(isset($emailData['msg']) && !empty($emailData['msg'])){
                    $subject = $emailData['msg'];
                } else {
                    $subject = 'NEW TASK #'.$emailData['ticket_no'];
                }
                
                $this->email->subject($subject);
                $this->email->message($message);
                $this->email->send();
            }
        }

	/* START :: VIEW */
		public function js_attnd_get($task_id=null){
			$user_id 	= $this->input->get('user_id');
            $taskAttnd  = $this->OP_TaskService->getTaskAttndListing($task_id);

            if(!empty($taskAttnd)){
            	foreach ($taskAttnd as $k => $val) {
            		$taskAttnd[$k]['check_in']  = sysDateTimeFormat($val['check_in']);
            		$taskAttnd[$k]['check_out'] = sysDateTimeFormat($val['check_out']);
            	}

            	$this->response([
                    'http_status_code' => REST_Controller::HTTP_OK,
                    'status' => true,
                    'attnd'  => $taskAttnd
                ], REST_Controller::HTTP_OK);
            } else {
            	$this->response([
                    'http_status_code' => REST_Controller::HTTP_OK,
                    'status' 	=> false,
                ], REST_Controller::HTTP_OK);
            }
		}

		public function js_get($task_id=null){
			$user_id 	= $this->input->get('user_id');
            $myTask     = false;
            // $taskAttnd  = $this->OP_TaskService->getTaskAttndListing($task_id);

            $lastAttndRecord = $this->OP_TaskService->_last_attnd_record($task_id, $user_id);
            $hasSignedIn     = $this->OP_TaskService->checkHasSignedIn($task_id, $user_id);
            $hasCheckedIn    = $this->OP_TaskService->_get_signin_status($hasSignedIn);
            // $task            = $this->OP_TaskService->getTaskDetail($task_id);
            $assigned 		 = $this->OP_TaskService->getAssignedTo($task_id);
            // $taskAttnd       = $this->OP_TaskService->getTaskAttndListing($task_id);
            // $comment         = $this->OP_TaskService->getCommentListing($task_id);
            $jobsheets       = $this->JobsheetService->_jobsheet_by_task($task_id);
            $js              = [];
            $TaskNotYetEnded = FALSE;
            $HasJs           = FALSE;

            if(!empty($assigned)){
                $assignedID = array_column($assigned, 'user_id');
                foreach ($assignedID as $id) {
                    if($id == $user_id){
                        $myTask = true;
                        break;
                    }
                }
                // $myTask = array_search($user_id, array_column($assigned, 'user_id'));
            }

            if(!empty($lastAttndRecord)){
                $lastAttndRecord['js'] = $this->DatabaseModel->readOneWithOptions(['taskattnd_id' => $lastAttndRecord['id']], 'id', $this->TableService->Jobsheet);
                $TaskNotYetEnded       = isEmptyTimestamp($lastAttndRecord['check_out']);   // TRUE : FALSE
                $HasJs                 = !empty($lastAttndRecord['js']) ? TRUE : FALSE;
            }

            if(!empty($jobsheets)){
                foreach ($jobsheets as $k => $val) {
                    // $js[$k] = $val;
                    $jobsheets[$k]['mileage'] = !empty($val['mileage']) && $val['mileage'] != 'NULL' ? $val['mileage']/100 : '';
                    $jobsheets[$k]['mileage_to_origin'] = !empty($val['mileage_to_origin']) && $val['mileage_to_origin'] != 'NULL' ? $val['mileage_to_origin']/100 : '';
                    $jobsheets[$k]['charges'] = $this->JobsheetService->_jobsheet_by_task($val['id']);
                    $jobsheets[$k]['created_date'] = sysDateTimeFormat($val['created_date']);
                }
            }

            $this->response([
                'http_status_code'  => REST_Controller::HTTP_OK,
                'status'            => true,
                'js'                => $jobsheets,
                'TaskNotYetEnded'   => $TaskNotYetEnded,      // if not yet ended disable input and show end task button
                'HasJs'             => $HasJs,      // used to check if there is js already written so can disable the write js input
                'myTask'            => $myTask,     // used to identify if can start start or not
                'lastAttndRecord'   => $lastAttndRecord,
            ], REST_Controller::HTTP_OK);

            /*return [
                'task'               => $task,
                'user'               => $user,
                'taskAttnd'          => $taskAttnd,
                'comment'            => $comment,
                'jobsheets'          => $jobsheets,
                'teams'              => $teams,
                'hasCheckedIn'       => $hasCheckedIn,    // :: to enable commenting. as long as there has task signed in and commenting will be enabled :: DEPRECATED!!!
                'lastAttndRecord_ID' => $TaskNotYetEnded ? $lastAttndRecord['id'] : 0,
                'TaskNotYetEnded'    => $TaskNotYetEnded,  // :: to enable START/END task and write JOBSHEET
                'HasJs'              => $HasJs,
            ];*/
		}

		public function comment_get($task_id=null){
			$user_id 		 = $this->input->get('user_id');
			$comment_type 	 = $this->input->get('comment_type');
            $assigned 		 = $this->OP_TaskService->getAssignedTo($task_id);
            $comment 		 = $this->OP_TaskService->getCommentListing($task_id);

            if(!empty($comment)){
            	$_comment_type = $comment_type === 'internal' ? 1 : 3;
            	foreach ($comment as $k => $val) {
            		if($val['comment_type'] == $_comment_type){
            			$filtered_comment[] = $val;
            		}
            	}
            }

            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status'  => isset($filtered_comment) ? true : false,
                'comment' => !empty($filtered_comment) ? $filtered_comment : null,
            ], REST_Controller::HTTP_OK);
		}

		// :: FOR JOBSHEET COMMENT
		public function submit_update_comment_post($task_id){
			$user_id 	   = $this->input->get('user_id') ? $this->input->get('user_id') : 0;
            $this->profile = $this->UserService->_employee_detail($user_id);
			$comment_type  = $this->input->get('comment_type') ? $this->input->get('comment_type') : null;
			$taskattnd_id  = $this->input->get('taskattnd_id') ? $this->input->get('taskattnd_id') : 0;

			# get the last JS (only for new js submitted)
            $js = $this->DatabaseModel->readOneWithOptionsOrderBy(['task_id' => $task_id], 'id, code', 'id DESC', $this->TableService->Jobsheet);
            if(!empty($js)){
                $last_jsCode = str_replace('JS', '', $js['code']);
                $jsCode      = ($last_jsCode + 1);
            } else {
                $jsCode = 1;
            }

            $this->form_validation->set_rules('comment', 'Comment', 'trim|required');

            if($this->form_validation->run() == true){
                $sql = 'SELECT ticket_id, codename_id FROM Task WHERE Task.id = '.$task_id;
                $taskDetails = $this->DatabaseModel->readOneQuery($sql);
                $commentedBy = $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id], 'code_name', 'Employee');

                if($comment_type === 'submit'){
                	$postData = [
                        'task_id'       => $task_id,
                        'commentby_id'  => $user_id,
                        'comment'       => $this->input->post('comment'),
                        'created_date'  => getCurrentTimeStamp(),
                        'taskattnd_id'  => $taskattnd_id
                    ];

                    $js_id   = $this->DatabaseModel->createData($postData, $this->TableService->Jobsheet);
                    $js_code = jsIntPrefix($jsCode);

                    $this->DatabaseModel->updateData(['id' => $js_id], ['code' => $js_code], $this->TableService->Jobsheet);
                    $this->DatabaseModel->createData(['task_id' => $task_id, 'js_id' => $js_id], $this->TableService->JsOtherCharge);
                    $this->DatabaseModel->createData(['js_id' => $js_id], $this->TableService->JsTotalCharge);

                    if(!empty($taskDetails)){
                        $ticketID = $taskDetails['ticket_id'].'-'.$js_code;
                        $this->NotificationsService->_notify_js_created(
                            $task_id, $ticketID, $this->profile['code_name'], $taskDetails['codename_id']
                        );

                        $emailData = $this->TaskService->_get_task_data_for_email($task_id, $user_id);
                        $emailData['msg'] = notify_jsCreated($ticketID, $this->profile['code_name']);
                        $codenameDetails = $this->UserService->_codename_by_id($taskDetails['codename_id']);
                        if(!empty($codenameDetails)){
                            if(isset($codenameDetails['company']) && !empty($codenameDetails['company']['email'])){
                                // $this->notifyEmail($emailData, [
                                //     'to_email' => $codenameDetails['company']['email'],
                                //     'to_name'  => $codenameDetails['company']['company_name']
                                // ]);
                            }
                        }
                    }
                } else {
                    $js_id = $this->input->post('js_id') ? $this->input->post('js_id') : null;
                    $js    = $this->DatabaseModel->readOneWithOptions(['id' => $js_id], 'code', $this->TableService->Jobsheet);

                    $this->DatabaseModel->updateData(['id' => $js_id], [
                        'comment'       => $this->input->post('comment'),
                        'modified_date' => getCurrentTimeStamp(),
                        'is_edited'     => 1
                    ], $this->TableService->Jobsheet);

                    if(!empty($taskDetails) && !empty($js)){
                        $ticketID = $taskDetails['ticket_id'].'-'.$js['code'];
                        $this->NotificationsService->_notify_js_updated(
                            $task_id, $ticketID, $this->profile['code_name'], $taskDetails['codename_id']
                        );

                        $emailData = $this->TaskService->_get_task_data_for_email($task_id, $user_id);
                        $emailData['msg'] = notify_jsUpdated($ticketID, $this->profile['code_name']);
                        $codenameDetails = $this->UserService->_codename_by_id($taskDetails['codename_id']);
                        if(!empty($codenameDetails)){
                            if(isset($codenameDetails['company']) && !empty($codenameDetails['company']['email'])){
                                // $this->notifyEmail($emailData, [
                                //     'to_email' => $codenameDetails['company']['email'],
                                //     'to_name'  => $codenameDetails['company']['company_name']
                                // ]);
                            }
                        }
                    }
                }
                
                $this->response([
	                'http_status_code' => REST_Controller::HTTP_OK,
	                'status' => true,
	            ], REST_Controller::HTTP_OK);
            } else {
                $this->response([
	                'http_status_code' => REST_Controller::HTTP_OK,
	                'status' => false,
	            ], REST_Controller::HTTP_OK);
            }
        }

        // :: FOR NORMAL COMMENT
        public function submit_comment_post($task_id=null){
			$user_id 	  	 = $this->input->get('user_id') ? $this->input->get('user_id') : 0;
			$submission_type = $this->input->get('submission_type') ? $this->input->get('submission_type') : null;
			$comment_type 	 = $this->input->get('comment_type') ? $this->input->get('comment_type') : null;

            $this->form_validation->set_rules('comment', 'Comment', 'trim|required');
            /**
            * Type of comments (based on db)
            * 1:Internal, 2:Jobsheet, 3:ALT/LST Comment, 4:ALT/LST charges, 5:Charge to customer
            **/

            if($this->form_validation->run() == true){
            	$_comment_type = $comment_type === 'internal' ? 1 : 3;
                if($submission_type === 'submit'){
                	$postData = [
                        'task_id'       => $task_id,
                        'commentby_id'  => $user_id,
                        'comment_type' 	=> $_comment_type,
                        'comment'       => $this->input->post('comment'),
                        'created_date'  => getCurrentTimeStamp()
                    ];
                    $this->DatabaseModel->createData($postData, $this->TableService->TaskComment);
                } else {
                    $this->DatabaseModel->updateData(['id' => $this->input->post('comment_id')], [
                        'comment'       => $this->input->post('comment'),
                        'modified_date' => getCurrentTimeStamp(),
                        'is_edited'     => 1
                    ], $this->TableService->TaskComment);
                }
                
                $this->response([
	                'http_status_code' => REST_Controller::HTTP_OK,
	                'status' => true,
	            ], REST_Controller::HTTP_OK);
            } else {
                $this->response([
	                'http_status_code' => REST_Controller::HTTP_OK,
	                'status' => false,
	            ], REST_Controller::HTTP_OK);
            }
        }

        public function delete_js_get($js_id=null){
            $this->DatabaseModel->deleteData(['id' => $js_id], $this->TableService->Jobsheet);
            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status'  => true,
            ], REST_Controller::HTTP_OK);
        }

        public function js_charges_get($task_id=null){
        	$user_id  = $this->input->get('user_id') ? $this->input->get('user_id') : 0;
        	$js_id    = $this->input->get('js_id') ? $this->input->get('js_id') : 0;
            $category = $this->SettingService->_all_hardware();
            $task     = $this->TaskService->_task_detail($task_id);
            $js       = $this->JobsheetService->_jobsheet_detail($js_id);
            $commentby_id = !empty($js['commentby_id']) ? $js['commentby_id'] : 0;

            $charges = $this->DatabaseModel->readArrayWithOptionsOrderBy(['js_id'=> $js_id
            ], 'id, charge_type, category_id, ssn, description, qty, price, amount, created_date, modified_date, is_edited', 'id ASC', self::$tbl->JsCharge);

            $otherCharge = $this->loadOtherChargeDetail($js_id);

            if(!empty($charges)){
            	foreach ($charges as $k => $val) {
            		$charges[$k]['charge_type_label'] = $val['charge_type'] == 1 ? 'Item' : 'Service';
            	}
            }

            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' 	=> true,
                'charges' 	=> $charges,
                'category' 	=> $category
            ], REST_Controller::HTTP_OK);
        }

        private function loadOtherChargeDetail($js_id){
            return $this->DatabaseModel->readOneWithOptions(['js_id' => $js_id], self::$field->JsOtherCharge, self::$tbl->JsOtherCharge);
        }

        public function generate_ssn_get(){
        	$sql      = 'SELECT id, SSN FROM '.self::$tbl->HardwareListing.' ORDER BY id DESC';
            $hardware = $this->DatabaseModel->readOneQuery($sql);
            $ssn      = !empty($hardware) ? $hardware['SSN'] : 0;
            $new_ssn  = ssnGenerator($ssn);
            $_ssn 	  = '';

            if(!empty($new_ssn)){
                $this->DatabaseModel->createData(['SSN' => $new_ssn], self::$tbl->HardwareListing);
                $_ssn = $new_ssn;
            }

            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' 	=> $_ssn != '' ? true : false,
                'ssn' 		=> $_ssn,
            ], REST_Controller::HTTP_OK);
        }

        public function add_item_row_post($task_id=null){
        	$mode  = $this->input->get('mode');
        	$js_id = $this->input->get('js_id') ? $this->input->get('js_id') : 0;

        	$chargeData = [
                'task_id'       => $task_id,
                'ssn'           => $this->input->post('ssn'),
                'js_id'         => $js_id,
                'created_date'  => getCurrentTimeStamp(),
            ];

            $postData = [
                'charge_type'  => $this->input->post('charge_type'),
                'ssn'          => $this->input->post('ssn'),
                'description'  => $this->input->post('description'),
                'qty'          => $this->input->post('qty'),
                'price'        => $this->input->post('price'),
                'hadrware_cat' => $this->input->post('hadrware_cat') ? $this->input->post('hadrware_cat') : null,
            ];

            if($mode === 'add'){
            	$charge_id = $this->DatabaseModel->createData($chargeData, self::$tbl->JsCharge);
            } else {
            	$charge_id = $this->input->post('charge_id');
            }

            $this->_update_charges($postData, $charge_id);

            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => true,
            ], REST_Controller::HTTP_OK);
        }

        private function _update_charges($post, $charge_id){
            $qty       = $post['qty'];
            $price     = $post['price'];
            $amount    = $qty > 0 ? ($qty*$price) : $price;

            $chargeData = [
                'charge_type'   => $post['charge_type'],
                'ssn'           => $post['ssn'],
                'description'   => $post['description'],
                'qty'           => $qty,
                'price'         => $price,
                'amount'        => $amount,
                'modified_date' => getCurrentTimeStamp()
            ];

            $hardwareData = [
                'item_desc' => $chargeData['description'],
                'cost'      => $chargeData['price']
            ];

            if(!empty($post['hadrware_cat'])){
                $chargeData['category_id']   = $post['hadrware_cat'];
                $hardwareData['category_id'] = $post['hadrware_cat'];
            }

            $this->DatabaseModel->updateData(['id' => $charge_id], $chargeData, self::$tbl->JsCharge);
            $this->DatabaseModel->updateData(['SSN' => $chargeData['ssn']], $hardwareData, self::$tbl->HardwareListing);
        }

        public function js_charges_detail_get($charge_id=null){
        	$charge = $this->DatabaseModel->readOneWithOptions(['id' => $charge_id], '*', self::$tbl->JsCharge);
        	$this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => !empty($charge) ? true : false,
                'charge' => $charge
            ], REST_Controller::HTTP_OK);
        }

        public function delete_charges_get($task_id=null){
        	$js_id 	   = $this->input->get('js_id') ? $this->input->get('js_id') : 0;
            $charge_id = $this->input->get('charge_id');
            $this->DatabaseModel->deleteData(['id' => $charge_id], self::$tbl->JsCharge);

            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => true,
            ], REST_Controller::HTTP_OK);
        }

        public function delete_comment_get($comment_id=null){
            $this->DatabaseModel->deleteData(['id' => $comment_id], self::$tbl->TaskComment);
            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => true,
            ], REST_Controller::HTTP_OK);
        }

        public function update_js_mileage_put($js_id=null){
            $data = json_decode(file_get_contents('php://input'), true);
            $mileage = NULL;
            if(!empty($data['mileage'])){
                if($data['mileage'] !== 'NULL'){
                    $mileage = $data['mileage']*100;
                }
            }
            $status = false;
            if($data['type'] === 'mileage'){
                $data = ['mileage' => $mileage];
            } else {
                $data = ['mileage_to_origin' => $mileage];
            }
            if(isset($data['mileage']) || isset($data['mileage_to_origin'])){
                $this->DatabaseModel->updateData(['id' => $js_id], $data, 'Jobsheet');
                $status = true;
            }

            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => $status,
                'data' => $data,
            ], REST_Controller::HTTP_OK);
        }

    /* START :: START & END TASK ACTIVITY */
        public function start_get($task_id=null){
        	# sign in @state = if true ? sign in needed : already signed in and need to sign out
        	$state 		   = false;
            $user_id       = $this->input->get('user_id') ? $this->input->get('user_id') : 0;
            $this->profile = $this->UserService->_employee_detail($user_id);
            $hasSignedIn   = $this->OP_TaskService->checkHasSignedIn($task_id, $user_id);
            $willNotify    = false;

            if(empty($hasSignedIn)){
                $state = true; $willNotify = true;
            } else {
                if(!isEmptyTimestamp($hasSignedIn['check_in']) && !isEmptyTimestamp($hasSignedIn['check_out'])){
                    // :: both check in and out done. need to start a new session.
                    $state = true; $willNotify = true;
                } else {
                    $state = false;
                }
            }

            if($willNotify){
                $emailData = $this->TaskService->_get_task_data_for_email($task_id, $user_id);
                $emailData['msg'] = notify_jsStarted($emailData['ticket_no'], $this->profile['code_name']);
                $taskData  = $this->DatabaseModel->readOneQuery('SELECT ticket_id, codename_id FROM Task WHERE Task.id = '.$task_id);
                $codenameDetails = $this->UserService->_codename_by_id($taskData['codename_id']);
                $attnd_id = $this->OP_TaskService->_record_checkin_task($task_id, $user_id);
                if(!empty($codenameDetails)){
                    if(isset($codenameDetails['company']) && !empty($codenameDetails['company']['email'])){
                        // $this->notifyEmail($emailData, [
                        //     'to_email' => $codenameDetails['company']['email'],
                        //     'to_name'  => $codenameDetails['company']['company_name']
                        // ]);
                    }
                }
            }

            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => true,
                'state'  => $state,
                'attnd_id' => isset($attnd_id) ? $attnd_id : 0
            ], REST_Controller::HTTP_OK);
        }

        public function end_get($task_id=null){
            $user_id         = $this->input->get('user_id') ? $this->input->get('user_id') : 0;
            $lastAttndRecord = $this->OP_TaskService->_last_attnd_record($task_id, $user_id);
            $this->profile   = $this->UserService->_employee_detail($user_id);

            if(!empty($lastAttndRecord)){
                $js = $this->DatabaseModel->readOneWithOptions(['taskattnd_id' => $lastAttndRecord['id']], 'id, taskattnd_id', self::$tbl->Jobsheet);

                $taskattnd_id = !empty($js) ? $js['taskattnd_id'] : $lastAttndRecord['id'];

                $timeOut = getCurrentTimeStamp();
                $this->DatabaseModel->updateData(['id' => $taskattnd_id], ['check_out' => $timeOut], self::$tbl->TaskAttnd);

                /**
                 * update js sales invoice item (the first row) which was created at 
                 * application\controllers\v1\task\ChargesController.php at function _update_invoice()
                 * variable $svc_detail
                 */
                $ItemSales = $this->DatabaseModel->readOneQuery(
                    'SELECT Item.id, Item.item_desc FROM ItemSales
                     LEFT JOIN Item ON Item.id = ItemSales.item_id
                     LEFT JOIN Invoice_Sales ON Invoice_Sales.id = ItemSales.invoice_id
                     WHERE Invoice_Sales.js_id = '.$js['id'].'
                     ORDER BY ItemSales.created_date DESC LIMIT 1'
                );
                if(!empty($ItemSales)){
                    $timeout = sysTimeFormatReadAM($timeOut);
                    $itemDesc = $ItemSales['item_desc'].' '.$timeOut;
                }

                # notification start
                $sql = 'SELECT 
                            Task.ticket_id, 
                            Task.codename_id,
                            Task.createdby_id, 
                            Employee.code_name 
                        FROM Task
                        LEFT JOIN Employee ON Employee.user_id = Task.createdby_id
                        WHERE Task.id = '.$task_id;
                $taskDetails = $this->DatabaseModel->readOneQuery($sql);
                if(!empty($taskDetails)){
                    $this->NotificationsService->_notify_js_ended(
                        $task_id, $taskDetails['ticket_id'], $this->profile['code_name'], $taskDetails['codename_id']
                    );

                    $emailData = $this->TaskService->_get_task_data_for_email($task_id, $user_id);
                    $emailData['msg'] = notify_jsEnded($emailData['ticket_no'], $this->profile['code_name']);
                    $codenameDetails = $this->UserService->_codename_by_id($taskDetails['codename_id']);
                    if(!empty($codenameDetails)){
                        if(isset($codenameDetails['company']) && !empty($codenameDetails['company']['email'])){
                            // $this->notifyEmail($emailData, [
                            //     'to_email' => $codenameDetails['company']['email'],
                            //     'to_name'  => $codenameDetails['company']['company_name']
                            // ]);
                        }
                    }
                }
            }

            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => true,
                'state'  => true
            ], REST_Controller::HTTP_OK);
        }

    /* START :: VERIFY JS */
        public function verify_js_get($task_id=null, $js_id=null){
            $this->user_id      = $this->input->get('user_id') ? $this->input->get('user_id') : null;
            $this->user_access  = $this->AccessService->_user_access($this->user_id);
            //$component = $this->TaskMainService->verify_platform($task_id, $this->data);
            $task = $this->TaskService->_task_detail($task_id);
            $js   = $this->JobsheetService->_jobsheet_detail($js_id);

            // print_array($js); exit();

            $this->data['task'] = $task;
            $this->data['js']   = $js;
            $this->data['user'] = isset($js['by']) ? $js['by'] : null;
            $this->data['sign_upload_url'] = base_url('sign-upload/'.$js_id);
            $this->load->view('api/task/js-form.tpl.php', $this->data);
        }

        public function sign_upload_post($js_id=null){
            //define('UPLOAD_DIR', 'assets/upload/sign/');
            if(isset($_POST['image_base64'])){
                $verifierData = [
                    'verifier_name' => $this->input->post('verifier_name'),
                    'verifier_ic'   => $this->input->post('verifier_ic'),
                ];

                $image_parts    = explode(";base64,", $_POST['image_base64']);
                $image_type_aux = explode("image/", $image_parts[0]);
                $image_type     = $image_type_aux[1];
                $image_base64   = base64_decode($image_parts[1]);
                //$file = $_SERVER["DOCUMENT_ROOT"].'/assets/upload/'. uniqid().'.png';
                $imgName        = uniqid().'.png';
                $file           = SIGN_DIR.$imgName;
                
                $jsData = [
                    'verifier'      => json_encode($verifierData),
                    'sign'          => $imgName,
                    'is_verified'   => 1
                ];
                // print_array($jsData); exit();

                file_put_contents($file, $image_base64);
                $this->DatabaseModel->updateData(['id' => $js_id], $jsData, self::$tbl->Jobsheet);
                $this->_generate_js_pdf($js_id, 'ref');
                echo true;
            }
        }

        private function _generate_js_pdf($js_id, $type){
            $this->data['type']     = $type === 'ref' ? 'REFERENCE' : 'FINAL';
            $this->data['js_note']  = $type === 'ref' ? 'This jobsheet is not final and only be used for reference purpose. We will send a completed one with invoice included.' : '';
            $this->data['logo']     = LOGO_PATH;
            $this->data['js']       = $this->JobsheetService->_jobsheet_detail($js_id);
            $this->data['task']     = $this->TaskService->_task_detail($this->data['js']['task_id']);

            $dompdf = new Dompdf\Dompdf();
            $html   = $this->load->view('api/task/js-pdf-generate.tpl.php', $this->data, true);
            $dompdf->loadHtml($html);
            $dompdf->set_option('isRemoteEnabled', true);
            $dompdf->setPaper('A4', 'portrait');
            $dompdf->render();

            $pdf        = $dompdf->output();
            $pdfName    = uniqid().'.pdf';
            
            $upload_path = UPLOAD_PATH.'/js/'.$pdfName;
            if(file_put_contents($upload_path, $pdf)){
                $this->DatabaseModel->updateData(['id' => $js_id], [
                    'pdf_name' => $pdfName
                ], self::$tbl->Jobsheet);

                if(isset($this->data['task']['customer']['company']['email']) && !empty($this->data['task']['customer']['company']['email'])){
                    if(MODE === 'PRODUCTION' || MODE === 'TEST'){
                        $ReceipientEmailAddr = $this->data['task']['customer']['company']['email'];
                    } else {
                        $ReceipientEmailAddr = 'testing.mael@gmail.com';
                    }

                    ob_start();
                    $this->load->view('api/task/js-email.tpl.php', $this->data);
                    $message = ob_get_clean();

                    $this->load->library('PHPMailer_Library');
                    $objMail = $this->phpmailer_library->load(TRUE);

                    $objMail->setFrom('noreply@smarter.com.my', 'Smarter Computer Sdn Bhd');
                    $this->email->to($ReceipientEmailAddr, $this->data['task']['customer']['company']['company_name']);
                    $objMail->addReplyTo('noreply@smarter.com.my', 'Smarter Computer Sdn Bhd');
                    $objMail->addAttachment(UPLOAD_PATH.'/js/'.$pdfName);

                    $objMail->isHTML(true);
                    $objMail->Subject = 'JOBSHEET ('.$this->data['task']['ticket_id'].'-'.$this->data['js']['code'].')';
                    $objMail->Body    = $message;
                    $objMail->AltBody = $message;
                    return ( $objMail->send() ? TRUE : FALSE );
                }
            }
        }
}