<?php defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';
class OTController extends REST_Controller {

    private $Services = [
        'AttendanceService' => 'AttendanceService',
        'task/TaskService'  => 'TaskService',
    ];

	function __construct() {
		parent::__construct();
		$this->load->service($this->Services);
    }
    
    public function record_get($user_id=null){
        $nextOffset = $this->input->get('nextOffset');
        $offset     = 0;
        $offset     = $nextOffset ? $nextOffset : $offset;

		$todaysOT 	  = $this->AttendanceService->_todays_ot($user_id);
		$site_task 	  = $this->TaskService->_assigned_site_task($user_id);
		$smarter_task = $this->TaskService->_assigned_smarter_task($user_id);

        $sql = 'SELECT Attnd_OT.*, Attnd_OTRequest.description FROM Attnd_OT
                LEFT JOIN Attnd_OTRequest ON Attnd_OTRequest.id = Attnd_OT.request_id
                WHERE Attnd_OT.user_id = '.$user_id.'
                ORDER BY Attnd_OT.checkin DESC LIMIT '.$offset.', 10';
		$rqArr = $this->DatabaseModel->readArrayQuery($sql);

		if(!empty($rqArr)){
			foreach ($rqArr as $k => $val) {
				$rq[$k] = $val;
				$rq[$k]['linked'] 	    	= $this->TaskService->_linked_task($val['request_id']);
				$rq[$k]['checkin']   = sysDateTimeFormat($val['checkin']);
				$rq[$k]['checkout']  = sysDateTimeFormat($val['checkout']);
				$rq[$k]['in_label']  = !isEmptyTimestamp($val['checkin']) ? $val['location_in'].' ('.$val['location_type_in'].')' : '';
				$rq[$k]['out_label'] = !isEmptyTimestamp($val['checkout']) ? $val['location_out'].' ('.$val['location_type_out'].')' : '';
				// $rq[$k]['rq_duration']  	= getHour($val['duration']).' H '.getMinutes($val['duration']).' MIN';
				// $rq[$k]['approve_label']  	= AttendanceService::_OT_APPROVAL[$val['is_approved']];
				// $rq[$k]['approve_color']  	= AttendanceService::_OT_APPROVAL_COLOR[$val['is_approved']];
				// $rq[$k]['status_label'] 	= AttendanceService::_OT_STATUS[$val['status']] === '-' ? '' : AttendanceService::_OT_STATUS[$val['status']];
				// $rq[$k]['status_color']  	= AttendanceService::_OT_STATUS_COLOR[$val['status']];
				// $rq[$k]['rq_date'] 			= getSysOnlyDate($val['rq_date']);
				// $rq[$k]['start_time'] 		= filterTime($val['start_time']);
			}
		}

		$datetime = new DateTime('tomorrow');
		
		$this->response([
            'status' 			=> true,
            'rq' 				=> isset($rq) ? $rq : [],
			'todaysOT'  		=> $todaysOT['to_check_in_out'],
			'hasOT'  			=> $todaysOT['has_ot_request'],
			'tomorrows_date'  	=> $datetime->format('d-m-Y'),
			'hasOT'  			=> $todaysOT['has_ot_request'],
			'nearestOT'   		=> $todaysOT['nearest_ot'],
			'site_task'  		=> $site_task,
			'smarter_task'  	=> $smarter_task,
			'rows'      		=> count($rq),
            'offset'    		=> count($rq) >= 10 ? $offset + 10 : $offset, # set for the next offset fetch
        ], REST_Controller::HTTP_OK);
    }

	public function request_get($user_id=null){
		$nextOffset = $this->input->get('nextOffset');
        $offset     = 0;
        $offset     = $nextOffset ? $nextOffset : $offset;

		$todaysOT 	  = $this->AttendanceService->_todays_ot($user_id);
		// $rqArr 	 	  = $this->DatabaseModel->readArrayWithOptionsOrderBy(['user_id' => $user_id], self::$field->OTRequest, 'created_date DESC', self::$tbl->OTRequest);
		$site_task 	  = $this->TaskService->_assigned_site_task($user_id);
		$smarter_task = $this->TaskService->_assigned_smarter_task($user_id);

		$sql = 'SELECT * FROM Attnd_OTRequest
                WHERE Attnd_OTRequest.user_id = '.$user_id.'
                ORDER BY created_date DESC LIMIT '.$offset.', 10';
		$rqArr = $this->DatabaseModel->readArrayQuery($sql);

		if(!empty($rqArr)){
			foreach ($rqArr as $k => $val) {
				$rq[$k] = $val;
				$rq[$k]['linked'] 	    	= $this->TaskService->_linked_task($val['id']);
				$rq[$k]['rq_duration']  	= getHourForOT($val['duration']).' H '.getMinutes($val['duration']).' MIN';
				$rq[$k]['approve_label']  	= AttendanceService::_OT_APPROVAL[$val['is_approved']];
				$rq[$k]['approve_color']  	= AttendanceService::_OT_APPROVAL_COLOR[$val['is_approved']];
				$rq[$k]['status_label'] 	= AttendanceService::_OT_STATUS[$val['status']] === '-' ? '' : AttendanceService::_OT_STATUS[$val['status']];
				$rq[$k]['status_color']  	= AttendanceService::_OT_STATUS_COLOR[$val['status']];
				$rq[$k]['rq_date'] 			= getSysOnlyDate($val['rq_date']);
				$rq[$k]['start_time'] 		= filterTime($val['start_time']);
			}
		}

		$datetime = new DateTime('tomorrow');
		
		$this->response([
            'status' 			=> true,
            'rq' 				=> isset($rq) ? $rq : [],
			'todaysOT'  		=> $todaysOT['to_check_in_out'],
			'hasOT'  			=> $todaysOT['has_ot_request'],
			'tomorrows_date'  	=> $datetime->format('d-m-Y'),
			'nearestOT'   		=> $todaysOT['nearest_ot'],
			'site_task'  		=> $site_task,
			'smarter_task'  	=> $smarter_task,
			'rows'      		=> count($rq),
            'offset'    		=> count($rq) >= 10 ? $offset + 10 : $offset, # set for the next offset fetch
        ], REST_Controller::HTTP_OK);
	}

}