<?php
class MY_Controller extends CI_Controller {
    public static $tbl          = '';
    public static $field        = '';
    // public static $root         = '';
    public static $conf_role    = '';
    public static $conf_dep     = '';

    private $Services = [
        'UserService' => 'UserService',
        'table/TableFieldService' => 'TableFieldService',
        'default/TableService' => 'TableService',
        'AccessService'        => 'AccessService',
        'NotificationsService' => 'NotificationsService',
        'PaginationService' => 'PaginationService'
    ];

    function __construct(){
        parent::__construct();

        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $method = $_SERVER['REQUEST_METHOD'];
        if($method == "OPTIONS") {
            die();
        }
        parent::__construct();
        
        $this->load->model('DatabaseModel');
        $this->load->service($this->Services);

        self::$tbl          = $this->TableService;
        self::$field        = $this->TableFieldService;
        // self::$root         = $this->RootService;
        self::$conf_role    = $this->config->item('role');
        self::$conf_dep     = $this->config->item('department');

        $this->access = $this->config->item('access');
    }

    /* START :: RESPONSE */
        public function response_success(){
            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => true,
            ], REST_Controller::HTTP_OK);
        }

        public function bad_request(){
            $this->response([
                'http_status_code' => REST_Controller::HTTP_BAD_REQUEST,
                'status' => false,
            ], REST_Controller::HTTP_BAD_REQUEST);
        }

        public function form_error_response($form_error){
            $this->response([
                'http_status_code' => REST_Controller::HTTP_OK,
                'status' => false,
                'formError' => $form_error,
            ], REST_Controller::HTTP_OK);
        }

    /* START :: IMAGE SECTION */
        public function upload_image($upload_path, $file, $fileName){
            $config['upload_path']          = $upload_path;
            $config['allowed_types']        = 'jpg|jpeg|png|gif';
            $config['max_size']             = 110000;

            $newFileName = seoUrl(removeExt($file['name']).'-'.uniqueId());
            $new_name = $newFileName.getExt($file['name']);
            $config['file_name'] = $new_name;

            $this->load->library('upload',$config);
            $this->upload->initialize($config);
            
            if($this->upload->do_upload($fileName)){
                $uploadData = $this->upload->data();
                $file_name = $uploadData['file_name'];

                $this->load->library('image_lib');

                if($file['size'] > $config['max_size']){
                    $configer = array(
                        'image_library'   => 'gd2',
                        'source_image'    => $uploadData['full_path'],
                        'create_thumb'    => FALSE,
                        'maintain_ratio'  => TRUE,
                        'width'           => 950,
                        'height'          => 950,
                    );

                    $this->image_lib->clear();
                    $this->image_lib->initialize($configer);
                    $this->image_lib->resize();
                }

                $configer = array(
                    'image_library'   => 'gd2',
                    'source_image'    => $uploadData['full_path'],
                    'create_thumb'    => TRUE,
                    'maintain_ratio'  => TRUE,
                    'width'           => 300,
                    'height'          => 300,
                );

                $this->image_lib->clear();
                $this->image_lib->initialize($configer);
                $this->image_lib->resize();

                $thumbName = $newFileName.'_thumb'.getExt($file['name']);
                rename($upload_path.'/'.$thumbName, $upload_path.'/thumbnail/'.$new_name);

                return $file_name;
            } else {
                return $this->upload->display_errors();
            }
        }

        public function upload_multiple_image($upload_path, $file, $fileName){
            $config['upload_path']          = $upload_path;
            $config['allowed_types']        = 'jpg|jpeg|png|gif';
            $config['max_size']             = 110000;

            $filesCount = count($file['name']);

            if($filesCount != 0){
                for($i = 0; $i < $filesCount; $i++){
                    $_FILES['userFile']['name'] = $file['name'][$i];
                    $_FILES['userFile']['type'] = $file['type'][$i];
                    $_FILES['userFile']['tmp_name'] = $file['tmp_name'][$i];
                    $_FILES['userFile']['error'] = $file['error'][$i];
                    $_FILES['userFile']['size'] = $file['size'][$i];   

                    $newFileName = seoUrl(removeExt($_FILES['userFile']['name']).'-'.uniqueId());
                    $new_name = $newFileName.getExt($_FILES['userFile']['name']);
                    $config['file_name'] = $new_name;

                    $this->load->library('image_lib');
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);

                    if($this->upload->do_upload('userFile')){
                        $uploadData = $this->upload->data();
                        $file_name[$i]['file_name'] = $uploadData['file_name'];

                        if($_FILES['userFile']['size'] > $config['max_size']){
                            $this->load->library('image_lib');
                            $configer = array(
                                'image_library'   => 'gd2',
                                'source_image'    => $uploadData['full_path'],
                                'create_thumb'    => FALSE,
                                'maintain_ratio'  => TRUE,
                                'width'           => 950,
                                'height'          => 950,
                            );

                            $this->image_lib->clear();
                            $this->image_lib->initialize($configer);
                            $this->image_lib->resize();
                        }

                        $configer = array(
                            'image_library'   => 'gd2',
                            'source_image'    => $uploadData['full_path'],
                            'create_thumb'    => TRUE,
                            'maintain_ratio'  => TRUE,
                            'width'           => 300,
                            'height'          => 300,
                        );

                        $this->image_lib->clear();
                        $this->image_lib->initialize($configer);
                        $this->image_lib->resize();

                        $thumbName = $newFileName.'_thumb'.getExt($_FILES['userFile']['name']);
                        rename($upload_path.'/'.$thumbName, $upload_path.'/thumbnail/'.$new_name);
                    } else {
                        return $this->upload->display_errors();
                    }
                }
                return $file_name;
            }
        }

        public function upload_avatar($upload_path, $file, $fileName){
            $config['upload_path']          = $upload_path;
            $config['allowed_types']        = '*';
            $config['max_size']             = 0;

            // $newFileName = seoUrl(removeExt($file['name']).'-'.uniqueId());
            // $new_name = $newFileName.getExt($file['name']);
            // $config['file_name'] = $new_name;

            $config['file_name'] = uniqid();

            $this->load->library('upload',$config);
            $this->upload->initialize($config);
            
            if($this->upload->do_upload($fileName)){
                $uploadData = $this->upload->data();
                $file_name = $uploadData['file_name'];

                $this->load->library('image_lib');
                $configer = array(
                    'image_library'   => 'gd2',
                    'source_image'    => $uploadData['full_path'],
                    'create_thumb'    => FALSE,
                    'maintain_ratio'  => TRUE,
                    'width'           => 500,
                    'height'          => 500,
                );

                $this->image_lib->clear();
                $this->image_lib->initialize($configer);
                $this->image_lib->resize();

                $result = array( 'status' => TRUE, 'file_name' => $file_name );
                return $result;
            } else {
                // return $this->upload->display_errors();
                return null;
            }
        }

        public function upload_files($upload_path, $file, $fileName, $file_types){
            $config['upload_path']          = $upload_path;
            $config['allowed_types']        = $file_types;
            $config['max_size']             = 0;

            $config['file_name'] = uniqid();

            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            
            if($this->upload->do_upload($fileName)){
                $uploadData = $this->upload->data();
                $file_name = $uploadData['file_name'];

                $ext = getExt($file_name);
                if(!in_array($ext, $this->config->item('video_ext'))){
                    $this->load->library('image_lib');

                    if($_FILES[$fileName]['size'] > 110000){
                        $configer = array(
                            'image_library'   => 'gd2',
                            'source_image'    => $uploadData['full_path'],
                            'create_thumb'    => FALSE,
                            'maintain_ratio'  => TRUE,
                            'width'           => 950,
                            'height'          => 950,
                        );

                        $this->image_lib->clear();
                        $this->image_lib->initialize($configer);
                        $this->image_lib->resize();
                    }
                } else {
                    if($uploadData['file_ext'] === '.mp4' || $uploadData['file_ext'] === '.MP4'){} else {
                        shell_exec("ffmpeg -i ".$uploadData['full_path']." -vcodec h264 -acodec aac -strict -2 ".$uploadData['file_path'].$uploadData['raw_name'].".mp4");

                        $this->unlinkFile($uploadData['full_path']);
                        $file_name = $uploadData['raw_name'].'.mp4';
                    }
                }

                return $file_name;
            } else {
                return $this->upload->display_errors();
            }
        }

    /* START :: UNLINK SECTION */
        public function unlinkFile($file_path){
            if(file_exists($file_path)){ unlink($file_path); }
        }

    /* START :: EMAIL SECTION */
        public function SendEmail($title, $greeting, $msg_content, $email_from, $email_to, $cc, $tpl){
            $this->load->helper('email');

            $data['title']          = $title;
            $data['greeting']       = $greeting;
            $data['msg_content']    = $msg_content;

            $message = $this->load->view($tpl, $data, true);

            $this->email->initialize(sendgridConfig());
            $this->email->from($email_from['email'], $email_from['fullname']);
            $this->email->to($email_to['email'], $email_to['fullname']);

            $cc != null ? $this->email->cc($cc['email'], $cc['fullname']) : null;

            $this->email->subject($title);
            $this->email->message($message);
            $this->email->send();
        }
}