<?php
defined('BASEPATH') OR exit('No direct script access allowed');

function getSvcGroupId(){ return 941; }

/* START :: ARRAY */
    function print_array($array,$color="#000"){
        echo '<pre style="color:'.$color.'">';
        print_r($array);
        echo '</pre>';
    }

    function getLastKey($array){
        end($array);
        $last = key($array);
        return $last;
    }

    function filterActiveCompany($company){
        $coArr = [];
        if(!empty($company)){
            foreach ($company as $k => $val) {
                if($val['is_active'] == 1){
                    $coArr[] = $val;
                }
            }
        }
        return $coArr;
    }

    function implodeStrArray($array=[]){
        return '"'.implode('","',$array).'"';
    }

/* START :: NUMBER & DECIMAL */
    function ssnGenerator($ssn=0){
        $string = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $char   = $string[mt_rand(0, strlen($string) - 1)];
        $lasInt = substr_replace($ssn, '', -1);
        return str_pad(($lasInt+1), 6, '300000', STR_PAD_LEFT).$char;
    }

    function removeSnAdditionalChar($ssn=null){
        # remove all alphabet and leave only numbers
        # sn format is something like 300000A / J300001A
        if(!empty($ssn)){
            return preg_replace("/[^0-9]/", "", $ssn);
        }
    }

    function snGenerator($nextSN = 0, $item_type = ''){
        # item_type = item || svc || tool
        # item = SSN, svc = JSN, tool = TSN
        $char   = range('A', 'Z');
        $nextSN = preg_replace("/[^0-9]/", "", $nextSN);    # remove the alphabet

        # smarter formula to get the last char
        $CheckDigitNum = (($nextSN * 7) + 7) % 26;
        if($CheckDigitNum == 0){
            $CheckDigitNum = 26;
        }
        
        # new SSN number must always start with 300000.
        # imported SSN number from external shouldn't be continued
        if($item_type === 'tool'){
            # T3001A = for tool
            $nextSN = $nextSN < 3001 ? 3000 : $nextSN;
        } else {
            $nextSN = $nextSN < 300000 ? 299999 : $nextSN;
        }

        $prefixNo = $item_type === 'tool' ? '3000' : '300000';
        if(isset($char[$CheckDigitNum])){
            $newSn = str_pad(($nextSN+1), strlen($prefixNo), $prefixNo, STR_PAD_LEFT).$char[$CheckDigitNum];
        } else {
            $newSn = str_pad(($nextSN+1), strlen($prefixNo), $prefixNo, STR_PAD_LEFT).'Z';
        }

        $snPrefix = '';
        switch ($item_type) {
            case 'svc':
                $snPrefix = 'J';
                break;
            case 'tool':
                $snPrefix = 'T';
                break;
            default:
                $snPrefix = '';
                break;
        }
        
        $newSn = trim($snPrefix.$newSn);
        return $newSn;
    }

    function docNoGenerator($nextDocNo = 0, $item_type = ''){
        # item_type = item || svc 
        # item = HQS, svc = HQZ
        $nextDocNo = preg_replace("/[^0-9]/", "", $nextDocNo);
        $newDocNo = str_pad(($nextDocNo+1), 5, '00000', STR_PAD_LEFT);
        $newDocNo = $item_type === 'svc' ? 'HQZ'.$newDocNo : 'HQS'.$newDocNo;
        return $newDocNo;
    }

    function stockTransferTxGenerator($nextTxNo = 0){
        $nextTxNo = preg_replace("/[^0-9]/", "", $nextTxNo);
        $newDocNo = str_pad(($nextTxNo+1), 5, '00000', STR_PAD_LEFT);
        $newDocNo = 'SX'.$newDocNo; // ssms transaction = SX
        return $newDocNo;
    }

    function batchNoGenerator($nextBatchNo = 0){
        # batch no format: BYYYY-MM-DD-NUM : where NUM is the number of how many times export button clicked. 
        # Once export button click considered exported
        # Eg: B2021-09-04-2
        // $nextBatchNo = preg_replace("/[^0-9]/", "", $nextBatchNo);
        // $newBatchNo = str_pad(($nextBatchNo+1), 5, '00000', STR_PAD_LEFT);
        // $newBatchNo = 'B'.$newBatchNo;
        $newBatchNo = 'B'.date('Y-m-d');
        return $newBatchNo;
    }

    function ticketNoPrefix($task_id, $comment_id){
        $task_prefix_id     = taskIntPrefix($task_id);
        $comment_prefix_id  = jsIntPrefix($comment_id);
        $ticket_no          = $task_prefix_id.'-JS'.$comment_prefix_id;
        return $ticket_no;
    }

    function taskIntPrefix($task_id=null){
        if((int) $task_id != null){
            return str_pad($task_id, 5, '0', STR_PAD_LEFT);
        } else {
            return false;
        }
    }

    function jsIntPrefix($comment_id=null){
        if((int) $comment_id != null){
            $id = str_pad($comment_id, 2, '0', STR_PAD_LEFT);
            return 'JS'.$id;
        } else {
            return false;
        }
    }

    function getNum($data){
        $num = substr($data, strpos($data, "-") + 1);
        return $num;
    }

    function round_decimal($decimal){ return round($decimal, 2); }
    function only_decimal($decimal){
        return number_format($decimal, 2, '.', '');
    }
    function leading_zero($num){
        if($num < 10){
            $length = strlen($num)+1;
            return str_pad($num, $length, '0', STR_PAD_LEFT);
        } else {
            return $num;
        }
    }

    function uniqueId($pattern = 1, $prefix = null){
        switch ($pattern) {
            case 1:
                return uniqid($prefix);
                break;
            
            default:
                return md5(time() . mt_rand(1, 10000000000));
                break;
        }
    }

    /**
     * Eg. of $str value '&lt;&lt;NEW&gt;&gt;22'
     * which is also translated to <<NEW>>22
     * this function is to extract and return the integer value 22 from claim voucher docno
     */
    // function extract_numbers_from_voucher_docno($str=''){
    //     if(!empty($str)){
    //         // First, use htmlspecialchars_decode() to convert the HTML entities back to their original characters
    //         $unescaped_str = htmlspecialchars_decode($str);
    //         // Use preg_match() to extract the integer number from the string
    //         preg_match('/\d+/', $unescaped_str, $matches);
    //         // The integer number is stored in the first element of the $matches array
    //         return $matches[0];
    //     }
    //     return null;
    // }

    /**
     * This function is similar as above but the params passed here is in "<<NEW>>n" format
     */
    function extract_numbers_from_voucher_docno($str=''){
        if(!empty($str)){
            // Replace the "<<" and ">>" characters with empty strings
            $str = str_replace("<<", "", $str);
            $str = str_replace(">>", "", $str);

            // Use preg_match() to extract the integer number from the string
            preg_match('/\d+/', $str, $matches);
            return $matches[0];
        }
        return null;
    }

    function extract_integer($string=null) {
        if(!empty($string)){
            preg_match_all('/\d+/', $string, $matches);
            return implode('', $matches[0]);
        } else {
            return 0;
        }
    }

/* START :: EXTENSION */
    function removeExt($file){ return pathinfo($file, PATHINFO_FILENAME); }
    function getExt($file){ return '.'.pathinfo($file, PATHINFO_EXTENSION); }

/* START :: BUTTON & STRING */
    function seoUrl($string) {
        //Unwanted:  {UPPERCASE} ; / ? : @ & = + $ , . ! ~ * ' ( )
        $string = strtolower($string);
        //Strip any unwanted characters
        $string = preg_replace("/[^a-z0-9_\s-]/", "", $string);
        //Clean multiple dashes or whitespaces
        $string = preg_replace("/[\s-]+/", " ", $string);
        //Convert whitespaces and underscore to dash
        $string = preg_replace("/[\s_]/", "-", $string);
        return $string;
    }

    function cutWords($string, $num){
        $pieces = explode(" ", $string);
        return implode(" ", array_splice($pieces, 0, $num));
    }

    function randomKey(){           md5(uniqid(rand(), true)); }
    function getFbProfile($fb_id){  return 'https://graph.facebook.com/'.$fb_id.'/picture?width=120&height=120'; }
    function trimSpaces($string){   return preg_replace('/\s+/', '', $string); }
    function getString($string){    return strtolower(trimSpaces($string)); }
    function tooltip($title){       return 'data-toggle="tooltip" title="'.$title.'"'; }
    function loadingBtn(){          return 'data-loading-text="<i class=\'fa fa-spinner fa-spin \'></i> Loading"'; }
    function btnLoading(){          return 'data-loading-text="<i class=\'fa fa-spinner fa-spin \'></i> Loading"'; }
    function getNameStr($string){   return ucfirst(strtolower($string)); }

    function url_seg_remover($url, $last_segment_number){
        $new_url = $url;
        for ($i=0; $i < $last_segment_number; $i++) { 
            $new_url = dirname($new_url);
        }
        return $new_url;
    }

    function claim_voucher_docno_format($docno=0){
        // to generate docno in <<NEW>>n format
        $formattedDocno = $docno > 0 ? htmlspecialchars("<<NEW>>".$docno) : "";
        return $formattedDocno;
    }

function includeLightbox(){
    return '
        <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/css/lightbox.min.css">
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/js/lightbox.min.js"></script>
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/js/lightbox-plus-jquery.min.js"></script>
    ';
}

/* START :: DATE & TIME */
    function date_listing($start_date, $end_date){
        # DateTime format : 2010-10-01
        $period = new DatePeriod(
            new DateTime($start_date),
            new DateInterval('P1D'),
            new DateTime($end_date)
        );

        if(!empty($period)){
            foreach( $period as $date) {
                $dateArr[] = $date->format('Y-m-d');
            }
        }

        return isset($dateArr) ? $dateArr : [];
    }

    function is_midnight($givenTime){
        // PHP Check if time is between two times regardless of date
        function TimeIsBetweenTwoTimes($from, $till, $input) {
            $f = DateTime::createFromFormat('H:i:s', $from);
            $t = DateTime::createFromFormat('H:i:s', $till);
            $i = DateTime::createFromFormat('H:i:s', $input);
            if ($f > $t) $t->modify('+1 day');
            return ($f <= $i && $i <= $t) || ($f <= $i->modify('+1 day') && $i <= $t);
        }

        $current_time = $givenTime;
        $from_time = "23:00:00";
        $to_time = "08:00:00";

        return TimeIsBetweenTwoTimes($from_time, $to_time, $current_time) ? 1 : 0;  # 1=Midnight, 0=Approval required
    }

    function year_short($year=null){ return date('y', strtotime($year)); }
    function isWeekend($date) { return (date('N', strtotime($date)) == 7); }
    
    # NEW - USE THESE FOR USER FRIENDLY NAMING
    function sysDateFormat($date){
        return !empty($date) && (int)$date > 0 ? date('d-m-Y', strtotime($date)) : false;
    }
    function sysDateNiceFormat($date){
        return !empty($date) && (int)$date > 0 ? date('d M Y', strtotime($date)) : false;
    }

    function sysTimeFormat($time){
        return !empty($time) && (int)$time > 0 ? date('h:i A', strtotime($time)) : false;
    }

    function sysTimeFormatReadAM($time){ return !empty($time) ? date('h:i A', strtotime($time)) : ''; }

    function sysDatetimeFormat($datetime){
        return !empty($date) || (int)$datetime > 0 ? date('d-m-Y h:i A', strtotime($datetime)) : false;
    }

    function sysYearFormat($date){
        return !empty($date) || (int)$date > 0 ? date('Y', strtotime($date)) : false;
    }

    function sysMonthFormat($date){
        return !empty($date) || (int)$date > 0 ? date('n', strtotime($date)) : false;
    }

    function sysMonthStringFormat($date){
        return !empty($date) || (int)$date > 0 ? date('F', strtotime($date)) : false;
    }

    function dateToday(){        date_default_timezone_set('Asia/Singapore'); return strtotime('today midnight'); }
    function currentTimeStamp($noChar=false){ 
        date_default_timezone_set('Asia/Singapore'); 
        return $noChar ? date('YmdHis') : date('Y-m-d H:i:s'); 
    }
    function currentTime(){      date_default_timezone_set('Asia/Singapore'); return date('H:i:s'); }
    function currentDate(){      date_default_timezone_set('Asia/Singapore'); return date('Y-m-d'); }
    function currentMonth(){     date_default_timezone_set('Asia/Singapore'); return date('m'); }
    function currentYear(){      date_default_timezone_set('Asia/Singapore'); return date('Y'); }

    function dbDateFormat($date){           return date('Y-m-d', strtotime($date)); }
    function dbTimeFormat($time){           return date('H:i:s', strtotime($time)); }
    function dbDateTimeFormat($datetime){   return date('Y-m-d H:i:s', strtotime($datetime)); }

    function getDays($start_date, $end_date){
        $date1 = new DateTime($start_date);
        $date2 = new DateTime($end_date);
        $days  = $date2->diff($date1)->format('%a');
        return $days;
    }

    function getMonths($start_date, $end_date){
        $date1 = new DateTime($start_date);
        $date2 = new DateTime($end_date);
        $diff  = $date2->diff($date1);
        $monthsDiff = (($diff->format('%y') * 12) + $diff->format('%m')) + 1;
        return $monthsDiff;
    }

    # make sure the $date_joined format is Y-m-d (Eg: 2021-10-01)
    # need to count only for this year. last year's balance will be keyed in manually from the template.
    function getEntitlementMonth($date_joined){
        $current_date   = currentDate();
        $current_year   = currentYear();
        $month_joined   = date('n', strtotime($date_joined));
        $year_joined    = date('Y', strtotime($date_joined));
        $day_joined     = date('j', strtotime($date_joined));  # day without leading 0
        $next_month     = $month_joined <= 12 ? $month_joined + 1 : 1;
        $target_year    = $month_joined <= 12 ? $year_joined : $year_joined + 1;
        $next_month_full_days    = cal_days_in_month(CAL_GREGORIAN,$next_month,$target_year);  # number of days on the target month
        $current_month_full_days = cal_days_in_month(CAL_GREGORIAN,$month_joined,$year_joined);

        # Eg logic calculation:
        # if date joined = 15 July 2021, current date = 15 August 2021, month completed = 0
        # if date joined = 15 July 2021, current date = 31 August 2021, month completed = 1

        if($current_year == $year_joined){
            # if day of date_joined not 1st
            if($day_joined > 1){
                # we will start calculating from the 1st day of the month because the completion month is to follow the calendar days
                $start_counting_date = $target_year.'-'.$next_month.'-01';
                $date_completed_one_month  = $target_year.'-'.$next_month.'-'.$next_month_full_days;
            } else {
                $start_counting_date = $date_joined;
                $date_completed_one_month  = $year_joined.'-'.$month_joined.'-'.$current_month_full_days;
            }
        } else {
            # year_joined is passed year so we will start calculating from the 1st jan of the year.
            $start_counting_date = $current_year.'-01-01';
            $target_month_full_days = cal_days_in_month(CAL_GREGORIAN,1,$current_year);
            $date_completed_one_month = $current_year.'-01-'.$target_month_full_days;
        }

        if(str_replace("-","",$current_date) < str_replace("-","",$date_completed_one_month)){
            # haven't reach one month yet so the entitle up to this month is 0
            return 0;
        }

        $date1 = new DateTime($start_counting_date);
        $date2 = new DateTime($current_date);
        $diff  = $date2->diff($date1);
        /*  Eg $diff result :
            DateInterval Object
            (
                [y] => 0
                [m] => 0
                [d] => 25
                [h] => 0
                [i] => 0
                [s] => 0
                [weekday] => 0
                [weekday_behavior] => 0
                [first_last_day_of] => 0
                [invert] => 1
                [days] => 25
                [special_type] => 0
                [special_amount] => 0
                [have_weekday_relative] => 0
                [have_special_relative] => 0
            )
        */
        $monthsDiff = (($diff->format('%y') * 12) + $diff->format('%m'));
        return $monthsDiff;
    }

    function getYears($start_date, $end_date){
        $date1 = new DateTime($start_date);
        $date2 = new DateTime($end_date);
        $diff  = $date2->diff($date1);
        $yearsDiff = $diff->format('%y') + 1;
        return $yearsDiff;
    }

    function getYearListing($start_date, $end_date){
        $endYear     = date('Y', strtotime($end_date));
        $startYear   = date('Y', strtotime($start_date));
        $yearListing = [];
        for ($year=$endYear; $year >= $startYear; $year--) { 
            array_push($yearListing, $year);
        }
        return $yearListing;
    }

    function hoursToMins($start_date, $end_date){
    	// remove the seconds and only calculate based on minutes
    	$startDataArr = explode(':', $start_date);
    	$endDateArr = explode(':', $end_date);
    	if(isset($startDataArr[2])){
    		$startDataArr[2] = '00';
    	}
    	if(isset($endDateArr[2])){
    		$endDateArr[2] = '00';
    	}
    	$start_date = implode(':', $startDataArr);
    	$end_date = implode(':', $endDateArr);

        $mins = 0;
        if(!isEmptyTimestamp($end_date)){
            $timeData = getTimeData($start_date, $end_date);
            $mins = ($timeData['hours'] * 60) + $timeData['min'];   // convert hours to minutes and plus with the remaining minutes
        }
        return $mins;   // return only in minutes and use hours converter to get hours
    }

    function minsToHours($mins){
        $duration = [ 'hours' => 0, 'min' => 0 ];
        if(!empty($mins)){
            if($mins > 60){
                $arr = explode('.', $mins / 60);
                $duration['hours'] = $arr[0];
                $duration['min'] = isset($arr[1]) ? round($arr[1]) : 0;
            } else {
                $duration['min'] = $mins;
            }
        }
        return $duration;
    }

    # time in minutes form. the output will be formatted in HH:MM
    function hoursandmins($timeInMinutes=0, $format = '%02d:%02d'){
        if ($timeInMinutes < 1) {
            return;
        }
        $hours = floor($timeInMinutes / 60);
        $minutes = ($timeInMinutes % 60);
        return sprintf($format, $hours, $minutes);
    }

    # get time difference
    function getTimeData($start_time, $end_time){
        if(isEmptyTimestamp($end_time) || $end_time == 0){
            $duration = $final_h = $final_m = 0;
        } else {
            $diff    = abs(strtotime($start_time) - strtotime($end_time));
            $tmins   = $diff/60;
            $hours   = floor($tmins/60);
            $mins    = $tmins%60;
            $final_h = leading_zero($hours);
            $final_m = leading_zero($mins);

            # return h:mm , Eg: 4:58
            $duration = $final_h.':'.$final_m;
        }
        
        return [
            'duration' => $duration,
            'hours'    => $final_h,
            'min'      => $final_m
        ];
    }

    function calculateTime($start_time, $end_time, $operator){
        if(isEmptyTimestamp($end_time) || $end_time == 0){
            $final_h = $final_m = '00';
        } else {
            if($operator === '+'){
                $diff   = abs(strtotime($start_time) + strtotime($end_time));
            } else {
                $diff   = abs(strtotime($start_time) - strtotime($end_time));
            }
            
            $tmins   = $diff/60;
            $hours   = floor($tmins/60);
            $mins    = $tmins%60;
            $final_h = leading_zero($hours);
            $final_m = leading_zero($mins);
        }
        return $final_h.':'.$final_m;
    }

    function plusTimeDuration($ot_duration, $completed_dur){
        $ot_dur      = $ot_duration > 0 ? explode(':', $ot_duration) : [0, 0];
        $completed   = explode(':', $completed_dur);
        $ot_h        = (isset($ot_dur[0]) ? $ot_dur[0] : 0) + (isset($completed[0]) ? $completed[0] : 0);
        $ot_m        = (isset($ot_dur[1]) ? $ot_dur[1] : 1) + (isset($completed[1]) ? $completed[1] : 1);
        $ot          = 0;

        if($ot_m > 60){
            $ot_m = $ot_m - 60;
            $ot_h = $ot_h + 1;
        }

        return leading_zero($ot_h).':'.leading_zero($ot_m);
    }

    function strTime($datetime){ return strtotime($datetime); }

    # OLD - SOME FUNCTIONS ARE STILL USING THESE HELPERS
    function getDateToday(){
        date_default_timezone_set('Asia/Singapore');
        return date('Y-m-d');
    }

    function getCurrentTimeStamp(){
        date_default_timezone_set('Asia/Singapore');
        return date('Y-m-d H:i:s');
    }

    function filterTime($datetime){
        return isEmptyTimestamp($datetime) ? 'N/A' : date('h:i A', strtotime($datetime));
    }

    function isEmptyTimestamp($timestamp){
        /* :: if TRUE = NULL, FALSE = !NULL */
        return empty($timestamp) || $timestamp === '0000-00-00 00:00:00' ? true : false;
    }

    function getSysDate($date){
        return $date === '0000-00-00 00:00:00' || empty($date) ? '-' : date('d-m-Y h:i A', strtotime($date));
    }

    function getSysOnlyDate($date){
        return $date === '0000-00-00 00:00:00' ? '-' : date('d-m-Y', strtotime($date));
    }

    function getHour($datetime){
        return !empty($datetime) ? date('h', strtotime($datetime)) : null;
    }

    function getHourForOT($datetime){
        if(!empty($datetime)){
            $timeArr = explode(':', $datetime);
            return $timeArr[0] > 0 ? date('h', strtotime($datetime)) : 0;
        }
    }

    function getMinutes($datetime){
        return !empty($datetime) ? date('i', strtotime($datetime)) : null;
    }

/**
 * FORMULA
 **/
 function calculateSPC($spc, $petrol_price, $km){
    return $km * ($petrol_price / $spc);
 }

 function calculateDailyRate($salary, $working_days){
    return only_decimal($salary / $working_days);
 }

 function calculateHourlyRate($salary, $working_days){
    $dailyRate = $salary / $working_days;
    return $dailyRate / 8;  // 8 Hours in a day
 }

function sendgridConfig(){
    // $config = array(
    //     'protocol'   => 'smtp',
    //     'smtp_host'  => 'smtp.sendgrid.net',
    //     'smtp_user'  => 'apikey',
    //     'smtp_pass'  => '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',
    //     'smtp_port'  => 587,
    //     'crlf'       => "\r\n",
    //     'newline'    => "\r\n",
    //     'charset'    => 'iso-8859-1',
    //     'wordwrap'   => TRUE,
    //     'mailtype'   => 'html',
    //     'validation' => TRUE, // bool whether to validate email or not
    // );

    $config = array(
        // 'protocol'   => 'smtp',
        // 'smtp_host'  => 'mail.gpnotes.com.sg',
        // 'smtp_user'  => '_mainaccount@gpnotes.com.sg',
        // 'smtp_pass'  => 'ic[!4%#dik2H',
        'smtp_port'  => 587,
        'crlf'       => "\r\n",
        'newline'    => "\r\n",
        'charset'    => 'iso-8859-1',
        'wordwrap'   => TRUE,
        'mailtype'   => 'html',
        'validation' => TRUE, // bool whether to validate email or not
    );

    return $config;
}

function tempDays(){
    $months = [
        5 => [
            'days' => 30,
            'sundays' => [3, 10, 17, 24, 31],
        ],
        6 => [
            'days' => 31,
            'sundays' => [7, 14, 21, 28],
        ],
        7 => [
            'days' => 31,
            'sundays' => [5, 12, 19, 26],
        ],
        8 => [
            'days' => 31,
            'sundays' => [2, 9, 16, 23, 30],
        ],
        9 => [
            'days' => 30,
            'sundays' => [6, 13, 20, 27],
        ],
        10 => [
            'days' => 31,
            'sundays' => [4, 11, 18, 25],
        ],
    ];

    return $months;
}

function alertText($text=""){
    $text = '<div class="alert alert-warning update-alert">';
    $text .= '<i class="fa fa-exclamation-circle"></i>';
    $text .= !empty($text) ? $text : 'You have made a changes. Please <b>save</b> your work before leaving this page.';
    $text .= '</div>';
    return $text;
}

?>