<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class DatabaseModel extends MY_Model {
    public function __construct(){
        parent::__construct();
    }

    /* START :: READ ARRAY */
        function readArray($field, $tableName){
            $this->db->select($field);
            $this->db->from($this->$tableName);

            $r = $this->db->get()->result_array();
            return !empty($r) ? $r : false;
        }

        function readArrayOrderBy($field, $order, $tableName){
            $this->db->select($field);
            $this->db->from($this->$tableName);
            $this->db->order_by($order);

            $r = $this->db->get()->result_array();
            return !empty($r) ? $r : false;
        }

        function readArrayWithOptions($options, $field, $tableName){
            $this->db->select($field);
            $this->db->from($this->$tableName);
            $this->db->where($options);

            $r = $this->db->get()->result_array();
            return !empty($r) ? $r : false;
        }

        function readArrayWithOptionsOrderBy($options, $field, $order, $tableName){
            $this->db->select($field);
            $this->db->from($this->$tableName);
            $this->db->where($options);
            $this->db->order_by($order);

            $r = $this->db->get()->result_array();
            return !empty($r) ? $r : false;
        }

    /* START :: READ ONE */
        function readOne($field, $tableName){
            $this->db->select($field);
            $this->db->from($this->$tableName);

            $r = $this->db->get()->row_array();
            return !empty($r) ? $r : false;
        }

        function readOneWithOptions($options, $field, $tableName){
            $this->db->select($field);
            $this->db->from($this->$tableName);
            $this->db->where($options);

            $r = $this->db->get()->row_array();
            return !empty($r) ? $r : false;
        }

        function readOneWithOptionsOrderBy($options, $field, $order, $tableName){
            $this->db->select($field);
            $this->db->from($this->$tableName);
            $this->db->where($options);
            $this->db->order_by($order);

            $r = $this->db->get()->row_array();
            return !empty($r) ? $r : false;
        }

    /* START :: QUERY */
        function readOneQuery($sql){
            $r = $this->db->query($sql)->row_array();
            return !empty($r) ? $r : false;
        }

        function readArrayQuery($sql){
            $r = $this->db->query($sql)->result_array();
            return !empty($r) ? $r : false;
        }

    /* START :: MANAGE */
        function createData($data, $tableName){
            $this->db->insert($this->$tableName, $data);
            $insert_id = $this->db->insert_id();
            return $insert_id;
        }

        function updateData($options, $data, $tableName){
            $this->db->where($options);
            $this->db->update($this->$tableName, $data);
            return true;
        }

        function deleteData($options, $tableName){
            $this->db->where($options);
            $this->db->delete($this->$tableName);
            return true;
        }

}