<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class AttendanceService extends MY_Service {

    const _OT_APPROVAL       = ['Pending', 'Approved', 'Declined'];
    const _OT_APPROVAL_COLOR = ['gray', 'green', 'red'];
    const _OT_STATUS         = ['-', 'In Progress', 'Completed'];
    const _OT_STATUS_COLOR   = ['gray', 'orange', 'green'];

    const _OT_PENDING  = 0;
    const _OT_APPROVE  = 1;
    const _OT_DECLINE  = 2;

    const _OT_INPROGRESS = 1;
    const _OT_COMPLETED  = 2;

    private $Services = [
        'task/TaskService' => 'task/TaskService',
        'CalendarService'  => 'CalendarService',
        'LeaveService'     => 'LeaveService'
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);
    }

    /* START :: ATTENDANCE RECORD */
    	public function _attnd_listing(){
    		return $this->DatabaseModel->readArray($this->TableFieldService->Attnd, $this->TableService->Attnd);
    	}

        public function emp_attnd_listing($user_id){
            $attnd = $this->DatabaseModel->readArrayWithOptionsOrderBy(['user_id' => $user_id], $this->TableFieldService->Attnd, 'checkin DESC', $this->TableService->Attnd);
            if(!empty($attnd)){
                foreach ($attnd as $k => $val) {
                    $attn[$k] = $val;
                    $attn[$k]['attndate'] = $this->_attnd_date($val['attnddate_id']);
                }
            }
            return isset($attn) ? $attn : [];
        }

        public function _emp_attnd_range($user_id, $date_from, $date_to){
            $dateArr = $dateData = null;
            $date_to = date('Y-m-d', strtotime($date_to . ' + 1 day'));
            $period  = new DatePeriod(
                new DateTime($date_from),
                new DateInterval('P1D'),
                new DateTime($date_to)
            );

            # Get the date range listing
            foreach ($period as $date) { $dateArr[] = $date->format('Y-m-d'); }

            if(!empty($dateArr)){
                foreach ($dateArr as $k => $date) {
                    $dateData[$k]['date']  = $date;
                    $dateData[$k]['attnd'] = $this->_attnd_listing_by_date_user($date, $user_id);
                    $dateData[$k]['ot']    = $this->_ot_listing_by_date_user($date, $user_id);
                    $dateData[$k]['leave'] = $this->_approved_paid_leave($user_id, $date);
                    // $dateData[$k]['ph']    = $this->CalendarService->_holiday_detail_by_date($user_id, $date);
                    $dateData[$k]['ph']    = $this->_get_holiday($user_id, $date);
                    $dateData[$k]['not_started_working'] = $this->_check_if_already_start_working($user_id, $date);
                }
            }
            return $dateData;
        }

        private function _check_if_already_start_working($user_id, $date){
            $user = $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id], 'date_joined', 'Employee');
            if(!empty($user)){

                return $user['date_joined'] < $date ? true : false;
            }
            return false;
        }

        private function _approved_paid_leave($user_id, $date){
            $sql = 'SELECT 
                        OptLeave.*, 
                        LeaveApplication.status, 
                        LeaveApplication.reason,
                        LeaveApplication.id AS application_id FROM LeaveApplication 
                    LEFT JOIN LeaveEntitlements ON LeaveEntitlements.id = LeaveApplication.entitlements_id
                    LEFT JOIN OptLeave ON  OptLeave.id = LeaveEntitlements.leave_id
                    WHERE ("'.$date.'" BETWEEN LeaveApplication.from_date AND LeaveApplication.to_date) 
                    AND LeaveApplication.user_id = '.$user_id.' 
                    AND LeaveApplication.status = 5
                    -- AND OptLeave.salary_deduction_applied = 0';
            $approvedPaidLeave = $this->DatabaseModel->readArrayQuery($sql);
            return $approvedPaidLeave;
        }

        private function _get_holiday($user_id, $date){
            $sql = 'SELECT * FROM CalendarHolidays
                    LEFT JOIN UserAddr ON UserAddr.state LIKE CONCAT("%", CONCAT(CalendarHolidays.region, "%"))
                    WHERE start = "'.$date.'"
                    AND UserAddr.ref = "user"
                    AND UserAddr.ref_id = '.$user_id;
            return $this->DatabaseModel->readOneQuery($sql);
        }

        public function _attnd_listing_by_date_user($date, $user_id){
            $sql  = 'SELECT * FROM '.$this->TableService->Attnd;
            $sql .= ' WHERE DATE_FORMAT(checkin, "%Y-%m-%d") = "'.$date.'"';
            $sql .= ' AND user_id = '.$user_id;
            $sql .= ' ORDER BY checkin ASC';
            $attnd = $this->DatabaseModel->readArrayQuery($sql);
            if(!empty($attnd)){
                foreach ($attnd as $k => $val) {
                    $newAttnd[$k] = $val;
                    $newAttnd[$k]['time'] = getTimeData($val['checkin'], $val['checkout']);
                }
            }
            return isset($newAttnd) ? $newAttnd : [];
        }

        public function _ot_listing_by_date_user($date, $user_id){
            $sql  = 'SELECT 
                        Attnd_OTDate.id AS attnd_otdate_id, 
                        Attnd_OTDate.created_date, 
                        Attnd_OT.checkin, 
                        Attnd_OT.checkout, 
                        Attnd_OTRequest.duration,
                        TIMESTAMPDIFF(MINUTE, Attnd_OT.checkin, Attnd_OT.checkout) AS duration_taken -- duration is in minutes 
                    FROM Attnd_OT 
                    LEFT JOIN Attnd_OTDate ON Attnd_OTDate.id = Attnd_OT.attnd_otdate_id 
                    LEFT JOIN Attnd_OTRequest ON Attnd_OTRequest.id = Attnd_OT.request_id 
                    WHERE DATE_FORMAT(checkin, "%Y-%m-%d") = "'.$date.'" 
                    AND Attnd_OTDate.user_id = '.$user_id.'
                    ORDER BY Attnd_OT.checkin ASC';

            $otArr = $this->DatabaseModel->readArrayQuery($sql);
            $newOT = null;

            if(!empty($otArr)){
                foreach ($otArr as $k => $val) {
                    $rqDuration     = explode(':', $val['duration']);
                    $rqDuration_h   = (int)$rqDuration[0];
                    $rqDuration_m   = (int)$rqDuration[1];
                    $rqDuration     = ($rqDuration_h * 60) + $rqDuration_m;     # convert time hours in minutes
                    $completed_dur  = 0;
                    
                    if(!empty($val['duration_taken'])){
                        if($val['duration_taken'] > $rqDuration){
                            # we only take the requested duration
                            $completed_dur = $rqDuration;
                        } else {
                            $completed_dur = $val['duration_taken'];
                        }
                    }

                    $newOT[$k] = $val;
                    $newOT[$k]['time'] = getTimeData($val['checkin'], $val['checkout']);
                    $newOT[$k]['completed_dur'] = $completed_dur;   # in minutes
                }
            }

            return $newOT;
        }

        public function _attnd_listing_by_date($date){
            $sql  = 'SELECT * FROM '.$this->TableService->Attnd;
            $sql .= ' WHERE DATE_FORMAT(checkin, "%Y-%m-%d") = "'.$date.'" ORDER BY checkin ASC';
            $attnd = $this->DatabaseModel->readArrayQuery($sql);
            if(!empty($attnd)){
                foreach ($attnd as $k => $val) {
                    $newAttnd[$k] = $val;
                    $newAttnd[$k]['time'] = getTimeData($val['checkin'], $val['checkout']);
                }
            }
            return isset($newAttnd) ? $newAttnd : [];
        }

        public function _ot_listing_by_date($date){
            $sql  = 'SELECT * FROM '.$this->TableService->OT;
            $sql .= ' WHERE DATE_FORMAT(checkin, "%Y-%m-%d") = "'.$date.'" ORDER BY checkin ASC';
            return $this->DatabaseModel->readArrayQuery($sql);
        }

        public function _attnd_date($attnddate_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $attnddate_id
            ], $this->TableFieldService->AttndDate, $this->TableService->AttndDate);
        }

    /* START :: OT RECORD */
        public function _ot_listing(){
            return $this->DatabaseModel->readArray($this->TableFieldService->OT, $this->TableService->OT);
        }

        public function emp_ot_listing($user_id){
            $overtime = $this->DatabaseModel->readArrayWithOptionsOrderBy(['user_id' => $user_id], $this->TableFieldService->OT, 'checkin DESC', $this->TableService->OT);
            if(!empty($overtime)){
                foreach ($overtime as $k => $val) {
                    $ot[$k] = $val;
                    $ot[$k]['attndate'] = $this->_ot_date($val['attnd_otdate_id']);
                }
            }
            return isset($ot) ? $ot : [];
        }

        public function _ot_date($attnddate_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $attnddate_id], $this->TableFieldService->OTDate, $this->TableService->OTDate);
        }

        public function _request_detail($request_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $request_id], $this->TableFieldService->OTRequest, $this->TableService->OTRequest);
        }

        /*public function _linked_task($request_id){
            $linked = $this->DatabaseModel->readArrayWithOptions(['request_id' =>$request_id], $this->TableFieldService->OTRequestTaskLinked, $this->TableService->OTRequestTaskLinked);
            if(!empty($linked)){
                foreach ($linked as $k => $val) {
                    $link[$k] = $val;
                    $link[$k]['task'] = $this->TaskService->_simple_task_detail($val['task_id']);
                }
            }
            return isset($link) ? $link : [];
        }*/

        /*private function _linked_task($request_id){
            $linkedArr = $this->DatabaseModel->readArrayWithOptions(['request_id' => $request_id], $this->TableFieldService->OTRequestTaskLinked, $this->TableService->OTRequestTaskLinked);
            if(!empty($linkedArr)){
                foreach ($linkedArr as $k => $val) {
                    $linked[$k] = $val;
                    if($val['task_type'] === 'site'){
                        $linked[$k]['task'] = $this->TaskService->_simple_task_detail($val['task_id']);
                    } else {
                        $linked[$k]['task'] = $this->TaskService->_smarter_task_detail($val['task_id']);
                    }
                }
            }
            return isset($linked) ? $linked : [];
        }*/

        public function _todays_ot($user_id){
            $setting  = $this->_ot_min_gap();
            $time_gap = '30 MINUTE';    // set as default by system, else get from setting
            if(!empty($setting)){
                $hour = getHour($setting['min_gap']);
                $min  = getMinutes($setting['min_gap']);
                $time_gap = $hour == 12 ? $min.' MINUTE' : $hour.' HOUR '.$min.' MINUTE';
            }

            $todaysDate      = getCurrentTimeStamp();
            $to_check_in_out = $this->_ot_by_date($todaysDate, $time_gap, $user_id);
            $has_ot_request  = $this->DatabaseModel->readArrayWithOptions(['user_id' => $user_id, 'is_approved' => self::_OT_APPROVE], $this->TableFieldService->OTRequest, $this->TableService->OTRequest);
            $nearest_ot      = $this->_nearest_ot($user_id);

            // print_array($nearest_ot); exit();

            if(!empty($nearest_ot)){
                if(!empty($setting)){
                    $hour = getHour($setting['min_gap']);
                    $min  = getMinutes($setting['min_gap']);
                    $_time_gap = $hour == 12 ? $min.' minutes' : $hour.' hours '.$min.' minutes';
                }

                $nearest_ot_time    = strtotime($nearest_ot['start_time']);
                $nearest_ot_minTime = date("h:i A", strtotime('-'.$_time_gap, $nearest_ot_time));
                $nearest_ot_maxTime = date("h:i A", strtotime('+'.$_time_gap, $nearest_ot_time));
                $nearest_ot['checkin_time'] = $nearest_ot_minTime.' - '.$nearest_ot_maxTime;
            }

            return [
                'to_check_in_out' => $to_check_in_out,
                'has_ot_request'  => empty($has_ot_request) ? false : true,
                'nearest_ot'      => $nearest_ot
            ];
        }

        private function _ot_by_date($datetime, $time_gap, $user_id){
            $sql = 'SELECT '.$this->TableFieldService->OTRequest.' FROM '.$this->TableService->OTRequest.' 
                    WHERE user_id = '.$user_id.'
                    AND (is_approved = '.self::_OT_APPROVE.' OR is_midnight = 1)
                    AND (start_time > DATE_SUB(NOW(), INTERVAL '.$time_gap.') AND start_time < DATE_ADD(NOW(), INTERVAL '.$time_gap.'))
                    ORDER BY created_date ASC';
            
            $ot = $this->DatabaseModel->readOneQuery($sql);
            if(!empty($ot)){
                $ot['linked'] = $this->TaskService->_linked_task($ot['id']);
                $ot['attnd']  = $this->TaskService->_linked_ot_attnd($ot['id']);
            }

            return $ot;
        }

        private function _nearest_ot($user_id){
            $sql = 'SELECT '.$this->TableFieldService->OTRequest.' FROM '.$this->TableService->OTRequest.' 
                    WHERE user_id = '.$user_id.' 
                    AND (is_approved = '.self::_OT_APPROVE.' OR is_midnight = 1) 
                    AND 
                        (
                            (rq_date = "'.currentDate().'" 
                                AND 
                                (
                                    (UNIX_TIMESTAMP(start_time) >= UNIX_TIMESTAMP()) 
                                    OR 
                                    (UNIX_TIMESTAMP(start_time) <= UNIX_TIMESTAMP())
                                )
                            ) 
                            OR 
                            (rq_date > "'.currentDate().'" 
                                AND 
                                (
                                    (UNIX_TIMESTAMP(start_time) >= UNIX_TIMESTAMP())
                                    OR
                                    (UNIX_TIMESTAMP(start_time) <= UNIX_TIMESTAMP())
                                )
                            )
                        ) 
                    ORDER BY start_time ASC';

            // print_array($sql); exit();

            /*$sql = 'SELECT '.$this->TableFieldService->OTRequest.' FROM '.$this->TableService->OTRequest.' 
                    WHERE (user_id = '.$user_id.' AND is_approved = '.self::_OT_APPROVE.' AND (rq_date = "'.currentDate().'" AND UNIX_TIMESTAMP(start_time) > UNIX_TIMESTAMP()))
                    OR (user_id = '.$user_id.' AND is_approved = '.self::_OT_APPROVE.' AND (rq_date > "'.currentDate().'" AND UNIX_TIMESTAMP(start_time) > UNIX_TIMESTAMP())) 
                    ORDER BY start_time ASC';*/

            // AND (rq_date = "'.currentDate().'" OR rq_date > "'.currentDate().'") 
            // AND ((rq_date = "'.currentDate().'" AND start_time >= UNIX_TIMESTAMP()) OR (rq_date > "'.currentDate().'" AND start_time >= UNIX_TIMESTAMP())) 
            return $this->DatabaseModel->readOneQuery($sql);
        }

        public function _ot_min_gap(){
            return $this->DatabaseModel->readOne($this->TableFieldService->OTSetting, $this->TableService->OTSetting);
        }

        public function _get_ot_last_available_checkout_time($start_time=null, $rq_duration=null){
            $startTimeDate      = dbDateFormat($start_time);
            $startTime          = dbTimeFormat($start_time);
            $hourDuration       = date('H', strtotime($rq_duration));
            $minutesDuration    = date('i', strtotime($rq_duration));
            $speculatedEndTime  = date('H:i', strtotime($startTime.'+'.$hourDuration.' hour'.'+'.$minutesDuration.' minutes'));
            $lastAvailableCheckoutTime = date('Y-m-d H:i', strtotime($speculatedEndTime.'+2 hour'));
            return $lastAvailableCheckoutTime;
        }

}