<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class CalendarService extends MY_Service {

    const _HOLS_NA          = 'na';
    const _HOLS_CUSTOM      = 'custom';
    const _HOLS_NATIONAL    = 'national';
    const _HOLS_REGIONAL    = 'regional';

    const _HOLS_TYPE = [
        'na'        => 'N/A',
        'custom'    => 'Smarter Holiday',
        'national'  => 'National Holiday',
        'regional'  => 'Regional Holiday'
    ];

	private $Services = [
        'hr/HrConfigService' 	=> 'HrConfigService',
        'UserService'           => 'UserService'
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);
    }

    /* START :: LISTING */
        public function _holiday_listing(){
            $this->_write_holiday();
            return $this->_this_year_holiday();
        }

        public function _holiday_listing_by_date($date){
            return $this->DatabaseModel->readArrayWithOptions(['start' => $date, 'status' => 'confirmed'
            ], $this->TableFieldService->CalendarHols, $this->TableService->CalendarHols);
        }

        public function _holiday_detail($calendar_id){
            $hols = $this->DatabaseModel->readOneWithOptions(['id' => $calendar_id], $this->TableFieldService->CalendarHols, $this->TableService->CalendarHols);
            if(!empty($hols)){
                if(!empty($hols['region'])){
                    $hols['region_arr'] = explode(', ', trim($hols['region']));
                }
            }
            return $hols;
        }

        public function _holiday_detail_by_date($user_id, $date){
            $ph   = [];
            $emp  = $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id], 'state', $this->TableService->UserAddr);
            $hols = $this->DatabaseModel->readOneWithOptions(['start' => $date], $this->TableFieldService->CalendarHols, $this->TableService->CalendarHols);
            if(!empty($hols)){
                if(!empty($hols['region'])){
                    $hols['region_arr'] = explode(', ', trim($hols['region']));
                    foreach ($hols['region_arr'] as $region) {
                        if($region === $emp['state']){
                            $ph = $hols;
                        }
                    }
                }
            }
            return $ph;
        }

        public function _this_year_holiday(){
            return $this->DatabaseModel->readArrayWithOptionsOrderBy(['year' => currentYear()
            ], $this->TableFieldService->CalendarHols, 'start ASC', $this->TableService->CalendarHols);
        }

    /* START :: REGISTER HOLIDAYS */
        public function _write_holiday(){
            $ThisYearHols = $this->_this_year_holiday();

            if(empty($ThisYearHols)){
                $holidaysArr = json_decode(file_get_contents('https://www.googleapis.com/calendar/v3/calendars/'.LANG.'.'.COUNTRY.'%23holiday%40group.v.calendar.google.com/events?key='.GOOGLE_API_KEY));
                $AllHols     = $this->DatabaseModel->readArray($this->TableFieldService->CalendarHols, $this->TableService->CalendarHols);

                if(empty($AllHols)){
                    $this->_register_all($holidaysArr);     // register all holidays
                } else {
                    $this->_register_year($holidaysArr);    // register only this year's holidays
                }
            }
        }

        private function _register_all($holidaysArr){
            if(!empty($holidaysArr) && !empty($holidaysArr->items)){
                foreach ($holidaysArr->items as $k => $val) {
                    $holidays = $this->DatabaseModel->readArrayWithOptions(['iCalUID' => $val->iCalUID
                    ], $this->TableFieldService->CalendarHols, $this->TableService->CalendarHols);

                    if(empty($holidays)){
                        $calendarData = [
                            'holiday_type'  => $this->_get_type($val),
                            'iCalUID'       => isset($val->iCalUID) ? $val->iCalUID : '',
                            'status'        => isset($val->status) ? $val->status : '',
                            'created'       => isset($val->created) ? dbDateTimeFormat($val->created) : '',
                            'updated'       => isset($val->updated) ? dbDateTimeFormat($val->updated) : '',
                            'summary'       => isset($val->summary) ? $val->summary : '',
                            'description'   => isset($val->description) ? $val->description : '',
                            'region'        => isset($val->description) ? str_replace('Holiday or observance in: ', '', $val->description) : '',
                            'start'         => isset($val->start->date) ? dbDateFormat($val->start->date) : 0,
                            'end'           => isset($val->end->date) ? dbDateFormat($val->end->date) : 0,
                            'year'          => isset($val->start->date) ? sysYearFormat($val->start->date) : 0
                        ];
                        //print_array($calendarData);
                        $this->DatabaseModel->createData($calendarData, $this->TableService->CalendarHols);
                    }
                }
            }
        }

        private function _register_year($holidaysArr)
        {
            if(!empty($holidaysArr) && !empty($holidaysArr->items))
            {
                foreach ($holidaysArr->items as $k => $val) 
                {
                    if(sysYearFormat($val->start->date) == currentYear())
                    {
                        $holidays = $this->DatabaseModel->readArrayWithOptions(['iCalUID' => $val->iCalUID
                        ], $this->TableFieldService->CalendarHols, $this->TableService->CalendarHols);

                        if(empty($holidays))
                        {
                            $calendarData = [
                                'holiday_type'  => $this->_get_type($val),
                                'iCalUID'       => isset($val->iCalUID) ? $val->iCalUID : '',
                                'status'        => isset($val->status) ? $val->status : '',
                                'created'       => isset($val->created) ? dbDateTimeFormat($val->created) : '',
                                'updated'       => isset($val->updated) ? dbDateTimeFormat($val->updated) : '',
                                'summary'       => isset($val->summary) ? $val->summary : '',
                                'description'   => isset($val->description) ? $val->description : '',
                                'region'        => isset($val->description) ? str_replace('Holiday or observance in: ', '', $val->description) : '',
                                'start'         => isset($val->start->date) ? dbDateFormat($val->start->date) : 0,
                                'end'           => isset($val->end->date) ? dbDateFormat($val->end->date) : 0,
                                'year'          => isset($val->start->date) ? sysYearFormat($val->start->date) : 0
                            ];
                            $this->DatabaseModel->createData($calendarData, $this->TableService->CalendarHols);
                        }
                    }
                }
            }
        }

        private function _get_type($hols){
            if(isset($hols->description)){
                if(strpos(trim($hols->description), 'observance')){
                    return self::_HOLS_REGIONAL;
                } else {
                    return self::_HOLS_NATIONAL;
                }
            } else {
                return self::_HOLS_NATIONAL;
            }
        }

    /* START :: SHARED FUNCTIONS */
        public function _explode_region($regionStr){
            return !empty($regionStr) ? explode(', ', trim($regionStr)) : '';
        }

        public function _implode_region($regionInput){
            $region = $regionInput;
            if(count($regionInput) > 1){
                $region = implode(', ', $regionInput);
            }
            return $region;
        }

}