<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class PaginationService extends MY_Service {

    function __construct(){
        parent::__construct();
    }

    // might need to remove later and use only _get_special_pagination
    public function _get_pagination($start, $limit, $where=null, $tableName){
        $sql        = 'SELECT COUNT(*) AS total FROM '.$tableName;
        $sql       .= ' '.$where;
        $rowTotal   = $this->DatabaseModel->readOneQuery($sql);

        if($rowTotal > 0){
            $pages = explode(".", $rowTotal['total'] / $limit);
            $pages = isset($pages[1]) ? $pages[0] + 1 : $pages[0];
        }

        return isset($pages) ? [
            'page'  => $pages,
            'rows'  => !empty($rowTotal) ? $rowTotal['total'] : 0,
            'start' => $start,
            'limit' => $limit
        ] : 0;
    }

    public function _get_special_pagination($start, $limit, $query, $derivedName){
        $sql        = 'SELECT COUNT(*) AS total FROM ('.$query.') AS '.$derivedName;
        $rowTotal   = $this->DatabaseModel->readOneQuery($sql);

        if($rowTotal > 0){
            $pages = explode(".", $rowTotal['total'] / $limit);
            $pages = isset($pages[1]) ? $pages[0] + 1 : $pages[0];
        }

        return isset($pages) ? [
            'page'  => $pages,
            'rows'  => !empty($rowTotal) ? $rowTotal['total'] : 0,
            'start' => $start,
            'limit' => $limit,
            'next'  => $limit + 50
        ] : 0;
    }

    public function _get_query_str($keys, $params, $isFirstParam=false){
        $queryStr = null;
        if(!empty($keys)){
            foreach ($keys as $key) {
                if($key !== "next"){
                    if(!empty($queryStr)){
                        $queryStr .= "&".$key."=".$params[$key];
                    } else {
                        $queryStr = ($isFirstParam ? "?" : "&").$key."=".$params[$key];
                    }
                }
            }
        }
        return $queryStr;
    }

    /**
     * @param $data [required]: 
     * is the $this->data or any array data to be merged in $this->data later in the controller
     * so that we don't have to add it in the query at every function
     * when working with the pagination
     * 
     * @param $sqlQuery [required]: 
     * SQL query without the START, LIMIT
     * 
     * @param $pages [optional]:
     * is the pages data array from function _get_pagination (might need to remove later) or _get_special_pagination.
     * it is the old params but we will keep it for now to avoid error from other functions that is still using it.
     * 
     * @param $sqlDerivedName [required]:
     * is SQL derived table
     * ref: https://logicalread.com/when-to-apply-sql-server-derived-tables-mc03/#.YgdpIt9ByMo
     */
    public function _get_pagination_params($data=[], $pages=[], $sqlQuery="", $sqlDerivedName=""){
        $next  = $this->input->get('next') ? $this->input->get('next') : 50;
        $start = $next - 50;
        $limit = $next;
        if(empty($pages)){
            $pages = $this->_get_special_pagination($start, $limit, $sqlQuery, $sqlDerivedName);
        }

        $params     = $this->input->get();
        $keys       = !empty($params) ? array_keys($params) : [];
        $queryStr   = $this->_get_query_str($keys, $params, $isFirstParam=true);

        $data['pages']        = $pages;
        $data['nextPage']     = !empty($queryStr) ? current_url().$queryStr.'&next=' : current_url().'?next=';
        $data['rowIndex']     = $pages['start']+1;
        return $data;
    }
}