<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class SettingService extends MY_Service {
    private $data = [];
    protected static $tbl;

    const _OP_SET_MILEAGE_CLAIM  = 1;
    const _OP_SET_ALTLST_COMMENT = 2;

	function __construct(){
        parent::__construct();
        
        //self::$tbl = $this->TableService;
    }

    /* START :: OPTIONAL SETTING FULL LISTING */
        public function _all_country(){
            return $this->DatabaseModel->readArrayWithOptionsOrderBy(['status' => 1], $this->TableFieldService->Nationality, 'country_name ASC', $this->TableService->Nationality);
        }

        public function _all_department(){
            return $this->DatabaseModel->readArray($this->TableFieldService->Dept, $this->TableService->Dept);
        }

        public function _all_user_type(){
            return $this->DatabaseModel->readArray($this->TableFieldService->UserType, $this->TableService->UserType);
        }

        public function _all_employment_type(){
            return $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->EmpType, 'title ASC', $this->TableService->EmpType);
        }

        public function _all_shift(){
            return $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->Shift, 'title ASC', $this->TableService->Shift);
        }

        public function _all_hardware(){
            return $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->HardwareCat, 'name ASC', $this->TableService->HardwareCat);
        }

        public function _all_office(){
            return $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->Office, 'name ASC', $this->TableService->Office);
        }

        public function _all_project(){
            return $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->Project, 'title ASC', $this->TableService->Project);
        }

        public function _claim_company_listing(){
            return $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->ClaimCompany, 'name ASC', $this->TableService->ClaimCompany);
        }

        public function _claim_acc_by_dep_listing($department_id){
            return $this->DatabaseModel->readArrayWithOptions([
                'department_id'    => $department_id
            ], $this->TableFieldService->ClaimAcc, $this->TableService->ClaimAcc);
        }

        public function _claim_acc_by_cat_dep($claimcategory_id, $department_id){
            return $this->DatabaseModel->readOneWithOptions([
                'claimcategory_id' => $claimcategory_id,
                'department_id'    => $department_id
            ], $this->TableFieldService->ClaimAcc, $this->TableService->ClaimAcc);
        }

        public function _claim_cat_detail($claimcategory_id){
            return $this->DatabaseModel->readOneWithOptions([
                'id'    => $claimcategory_id
            ], $this->TableFieldService->ClaimCat, $this->TableService->ClaimCat);
        }

        public function _all_state(){
            return $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->State, 'state_name ASC', $this->TableService->State);
        }

        public function _group_by_department($department_id){
            return $this->DatabaseModel->readArrayWithOptions(['department_id' => $department_id], $this->TableFieldService->AccessGrp, $this->TableService->AccessGrp);
        }

        public function _all_access_group(){
            $access_group = $this->DatabaseModel->readArray($this->TableFieldService->AccessGrp, $this->TableService->AccessGrp);
            if(!empty($access_group)){
                foreach ($access_group as $k => $val) {
                    $access_group[$k]['department'] = $this->_department_detail($val['department_id']);
                }
            }
            return $access_group;
        }

        /**
         * LOCATION
         **/
         public function _all_active_location(){
            $sql = 'SELECT ItemLocation.* FROM ItemLocation 
                    LEFT JOIN User ON User.id = ItemLocation.user_id
                    WHERE User.is_active = 1 AND ItemLocation.location != "" 
                    ORDER BY location ASC';
            return $this->DatabaseModel->readArrayQuery($sql);
         }

         public function _location_by_id($location_id=null){
            return $this->DatabaseModel->readOneWithOptions(['id' => $location_id], '*', 'ItemLocation');
         }

         public function _location_by_name($locationName=null){
             return $this->DatabaseModel->readOneWithOptions(['location' => $locationName], '*', 'ItemLocation');
         }

         public function _all_customer_active_location(){
             $sql = 'SELECT DISTINCT(location) FROM (
                SELECT ItemLocation.* FROM ItemLocation 
                LEFT JOIN User ON User.id = ItemLocation.user_id
                LEFT JOIN Company ON Company.id = User.company_id
                LEFT JOIN OptUserType ON OptUserType.id = Company.usertype_id
                WHERE User.is_active = 1 
                AND ItemLocation.location != "" 
                AND OptUserType.title = "CUSTOMER"
                ORDER BY location ASC
             ) ItemLocation';
            return $this->DatabaseModel->readArrayQuery($sql);
         }

         # all location
         public function _all_employee_active_location(){
             $sql = 'SELECT DISTINCT(location) FROM (
                SELECT ItemLocation.* FROM ItemLocation 
                LEFT JOIN User ON User.id = ItemLocation.user_id
                LEFT JOIN Company ON Company.id = User.company_id
                LEFT JOIN OptUserType ON OptUserType.id = Company.usertype_id
                WHERE User.is_active = 1 
                AND ItemLocation.location != "" 
                AND OptUserType.title = "EMPLOYEE"
                ORDER BY location ASC
             ) ItemLocation';
            return $this->DatabaseModel->readArrayQuery($sql);
         }

         # all location for single user
         public function _all_single_user_location($user_id=null, $userFilteredItemLocation=null){
            $sql = 'SELECT ItemLocation.* FROM ItemLocation 
                    WHERE ItemLocation.user_id = '.$user_id;
            if(!empty($userFilteredItemLocation)){
                $sql .= ' AND ItemLocation.location = "'.$userFilteredItemLocation.'"';
            }
            return $this->DatabaseModel->readArrayQuery($sql);
         }

        /**
         * ITEM
         **/
         public function _all_item(){
            return $this->DatabaseModel->readArrayWithOptions(['is_deleted' => 0, 'invoice_type' => 'purchase'], $this->TableFieldService->Item, $this->TableService->Item);
            // return $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->Item, 'id ASC', $this->TableService->Item);
         }

         public function _all_item_group(){
            return $this->DatabaseModel->readArrayOrderBy('*', 'name ASC', $this->TableService->ItemGroup);
         }

         public function _item_detail($item_id){
            $item = $this->DatabaseModel->readOneWithOptions(['id' => $item_id], $this->TableFieldService->Item, $this->TableService->Item);
            $itemLocation = $project = null;
            if(!empty($item)){
                $itemLocation = $this->DatabaseModel->readOneWithOptions(['id' => $item['location']], '*', $this->TableService->ItemLocation);
                $project = $this->_project_detail($item['project_code']);
            }
            $item['item_location'] = $itemLocation;
            $item['project'] = $project;
            return $item;
         }

         public function _item_group_detail($item_group_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $item_group_id], $this->TableFieldService->ItemGroup, $this->TableService->ItemGroup);
         }
        
        /** 
         * COMPANY SETTING
         **/
         public function _all_credit_terms(){
            return $this->DatabaseModel->readArray('*', 'CompanySetting_CreditTerms');
         }
         public function _credit_terms_by_id($credit_terms_id=null){
            return $this->DatabaseModel->readOneWithOptions(['id' => $credit_terms_id], '*', 'CompanySetting_CreditTerms');
         }

         public function _all_control_acc_code(){
            return $this->DatabaseModel->readArray('*', 'CompanySetting_ControlAccCode');
         }
         public function _control_acc_code_by_id($control_acc_code_id=null){
            return $this->DatabaseModel->readOneWithOptions(['id' => $control_acc_code_id], '*', 'CompanySetting_ControlAccCode');
         }

    /* START :: OPTIONAL SETTING DETAIL */
        public function _group_detail($group_id){
            $access_group = $this->DatabaseModel->readOneWithOptions(['id' => $group_id], $this->TableFieldService->AccessGrp, $this->TableService->AccessGrp);
            if(!empty($access_group)){
                $access_group['department'] = $this->_department_detail($access_group['department_id']);
            }
            return $access_group;
        }

        public function _department_detail($department_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $department_id], $this->TableFieldService->Dept, $this->TableService->Dept);
        }

        public function _user_type_detail($usertype_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $usertype_id], $this->TableFieldService->UserType, $this->TableService->UserType);
        }

        public function _team_by_department($department_id){
            return $this->DatabaseModel->readArrayWithOptionsOrderBy(['department_id' => $department_id
            ], 'id, title', 'title ASC', $this->TableService->Team);
        }

        public function _team_detail($department_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $department_id], $this->TableFieldService->Team, $this->TableService->Team);
        }

        public function _employment_type_detail($type_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $type_id], 'title', $this->TableService->EmpType);
        }

        public function _shift_detail($shift_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $shift_id], $this->TableFieldService->Shift, $this->TableService->Shift);
        }

        public function _get_department_permissions($department_id){
            return $this->DatabaseModel->readArrayWithOptionsOrderBy(['department_id' => $department_id, 'is_deprecated' => 0
            ], 'id, permission_type, permission_code, remark, is_deprecated', 'id ASC', $this->TableService->PermissionSetting);
        }

        public function _team_setting_listing($department_id, $team_id){
            return $this->DatabaseModel->readArrayWithOptions([
                'department_id' => $department_id,
                'optteam_id'    => $team_id
            ], $this->TableFieldService->SetTeam, $this->TableService->SetTeam);
        }

        public function _team_setting_by_team_id($team_id){
            return $this->DatabaseModel->readArrayWithOptions([
                'optteam_id'    => $team_id
            ], $this->TableFieldService->SetTeam, $this->TableService->SetTeam);
        }

        public function _project_detail($project_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $project_id], $this->TableFieldService->Project, $this->TableService->Project);
        }

        public function _company_on_receipt_detail($company_id){
            return $this->DatabaseModel->readOneWithOptions(['id' => $company_id], $this->TableFieldService->ClaimCompany, $this->TableService->ClaimCompany);
        }
        
        public function _claim_spc(){
            return $this->DatabaseModel->readOne($this->TableFieldService->ClaimSPC, $this->TableService->ClaimSPC);
        }

        public function _claim_spc_detail($state_id){
            return $this->DatabaseModel->readOneWithOptions(['state_id' => $state_id], $this->TableFieldService->ClaimSPC, $this->TableService->ClaimSPC);
        }

        public function _state_by_name($state){
            return $this->DatabaseModel->readOneWithOptions(['state_name' => trim($state)], $this->TableFieldService->State, $this->TableService->State);
        }
}