<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class UserService extends MY_Service {
    private $data = [];

    # ENSURE THAT THESE CODE SETTING FOLLOWS THE CODE FROM custom.php [DEPRECATED!!! -- 03 JULY 2021]
    const _CUSTOMER     = 1;
    const _STAFF        = 2;
    const _MANAGER      = 3;
    const _DIRECTOR     = 4;
    const _ADMIN        = 5;     // same as super admin :: default
    const _SUPPLIER     = 6;
    const _SUPERADMIN   = 5;     // same as admin

    const _ADDR_REF_USER    = 'user';
    const _ADDR_REF_COMPANY = 'company';
    const _ADDR_REF_BRANCH  = 'branch';

    # OLD ROLES - TO BE CONFIRMED
    /*const _CUSTOMER     = 1;
    const _STAFF        = 2;
    const _MANAGER      = 3;
    const _ADMIN        = 4;
    const _SUPERADMIN   = 5;
    const _SUPPLIER     = 6;*/

    const DEP_OPERATION = 1;
    const DEP_HR        = 2;
    const DEP_SALES     = 3;
    const DEP_ADMIN     = 4;
    const DEP_ACCOUNT   = 5;

    protected static $tbl;

    private $Services = [
        'SettingService' => 'SettingService',
    ];

    function __construct(){
        parent::__construct();
        $this->global_access = $this->config->item('access');
    }

    public function setUserLoggedSession($user_id, $username, $code_name, $department){
        if(!empty($user_id)){
            $this->session->set_userdata('userLogged', [
                'id'            => $user_id, 
                'username'      => $username,
                'code_name'     => $code_name, 
                'department'    => $department,
                'department_id' => 0,   // deprecated
                'team_id'       => 0,   // deprecated
                'position'      => '',  // deprecated
                'role_id'       => 0    // deprecated
            ]);
        }
    }

    /* START :: USER ADDITIONAL INFO & DETAILS */
        public function _user_by_group($group_id){
            $user = $this->DatabaseModel->readArrayWithOptions(['group_id' => $group_id], $this->TableFieldService->User, $this->TableService->User);
            if(!empty($user)){
                foreach ($user as $k => $val) {
                    $user[$k]['profile'] = $this->_employee_detail($val['id']);
                }
            }
            return $user;
        }

        public function _user_by_company($company_id){
            $user = $this->DatabaseModel->readArrayWithOptions(['company_id' => $company_id], $this->TableFieldService->User, $this->TableService->User);
            if(!empty($user)){
                foreach ($user as $k => $val) {
                    $user[$k]['profile'] = $this->_employee_detail($val['id']);
                }
            }
            return $user;
        }

        public function _all_company(){
            $company = $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->Company, 'created_date DESC', $this->TableService->Company);
            if(!empty($company)){
                foreach ($company as $k => $val) {
                    $code_name_detail = $this->_company_codename_detail('company', $val['id']);
                    $company[$k]['regby']       = $this->_user_detail($val['created_by']);
                    $company[$k]['user_type']   = $this->SettingService->_user_type_detail($val['usertype_id']);
                    $company[$k]['code_name']   = $this->_code_name_detail('company', $val['id']);
                    $company[$k]['is_active']   = $code_name_detail['is_active'];
                }
            }
            return $company;
        }

        public function _all_active_company(){
            $co = [];
            $company = $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->Company, 'created_date DESC', $this->TableService->Company);
            if(!empty($company)){
                foreach ($company as $k => $val) {
                    $code_name_detail = $this->_company_codename_detail('company', $val['id']);
                    $company[$k]['regby']       = $this->_user_detail($val['created_by']);
                    $company[$k]['user_type']   = $this->SettingService->_user_type_detail($val['usertype_id']);
                    $company[$k]['code_name']   = $this->_code_name_detail('company', $val['id']);
                    $company[$k]['is_active']   = $code_name_detail['is_active'];
                }
                foreach ($company as $k => $val) {
                    if($val['is_active'] == 1){
                        $co[] = $val;
                    }
                }
            }
            return $co;
        }

        public function _user_company_only($company, $company_id){
            $coArr = [];
            if(!empty($company)){
                foreach ($company as $k => $val) {
                    if($company_id == $val['ref_id'] && $val['ref'] === 'company'){
                        $coArr[] = $val;
                        break;
                    }
                }
            }
            return $coArr;
        }

        public function _user_company_and_branches_only($company, $company_id){
            $coArr = [];
            if(!empty($company)){
                foreach ($company as $k => $val) {
                    if($val['ref'] === 'company'){
                        if($company_id == $val['ref_id']){
                            $coArr[] = $val;
                            continue;
                        }
                    } else {
                        $hq = $this->DatabaseModel->readOneWithOptions(['company_id' => $company_id, 'id' => $val['ref_id']
                        ], 'company_id, branch_name', $this->TableService->Branch);
                        if(!empty($hq)){
                            $coArr[] = $val;
                            continue;
                        }
                    }
                }
            }
            return $coArr;
        }

        public function _codename_by_id($codename_id){
            // return all detail by code name id
            $code_name = $this->DatabaseModel->readOneWithOptions(['id' => $codename_id
            ], '*', $this->TableService->CompanyCodeName);

            if(!empty($code_name)){
                if($code_name['ref'] === 'company'){
                    $code_name['company'] = $this->_company_detail_limited($code_name['ref_id']);
                } else {
                    $code_name['company'] = $this->_branch_detail_limited($code_name['ref_id']);
                }
            }

            return !empty($code_name) ? $code_name : null;
        }

        public function _company_codename_detail($ref, $ref_id){
            // return all detail
            $code_name = $this->DatabaseModel->readOneWithOptions(['ref' => $ref, 'ref_id' => $ref_id
            ], $this->TableFieldService->CompanyCodeName, $this->TableService->CompanyCodeName);

            return !empty($code_name) ? $code_name : null;
        }

        public function _code_name_detail($ref, $ref_id){
            // @code_name String : return only code name
            $code_name = $this->DatabaseModel->readOneWithOptions(['ref' => $ref, 'ref_id' => $ref_id
            ], $this->TableFieldService->CompanyCodeName, $this->TableService->CompanyCodeName);

            return !empty($code_name) ? $code_name['code_name'] : null;
        }

        public function _company_detail($company_id){
            $company = $this->DatabaseModel->readOneWithOptions(['id' => $company_id], $this->TableFieldService->Company, $this->TableService->Company);
            if(!empty($company)){
                $company['regby']       = $this->_user_detail($company['created_by']);
                $company['user_type']   = $this->SettingService->_user_type_detail($company['usertype_id']);
            }
            return $company;
        }

        public function _branch_detail_limited($branch_id){
            $company = $this->DatabaseModel->readOneWithOptions(['id' => $branch_id], 'branch_name AS company_name, acc_code, email, phone_no, hp_no', $this->TableService->Branch);
            if(!empty($company)){
                $company['addr'] = $this->_full_addr($branch_id, 'branch');
            }
            return $company;
        }

        public function _company_detail_limited($company_id){
            $company = $this->DatabaseModel->readOneWithOptions(['id' => $company_id], 'company_name, acc_code, email, phone_no, hp_no, usertype_id', $this->TableService->Company);
            if(!empty($company)){
                $company['user_type']   = $this->SettingService->_user_type_detail($company['usertype_id']);
                $company['addr'] = $this->_full_addr($company_id, 'company');
            }
            return $company;
        }

        public function _branch_detail($branch_id){
            $branch = $this->DatabaseModel->readOneWithOptions(['id' => $branch_id], $this->TableFieldService->Branch, $this->TableService->Branch);
            if(!empty($branch)){
                $branch['hq'] = $this->_company_detail($branch['company_id']);
            }
            return $branch;
        }

        public function _employee_detail($user_id){
            $profile = $this->DatabaseModel->readOneWithOptions(['user_id' => $user_id
            ], $this->TableFieldService->Emp, $this->TableService->Emp);

            if(!empty($profile)){
                $profile['user'] = $this->_user_detail($user_id);
                $profile['item_location'] = $this->_user_item_location($user_id);
                // $emp['username']   = !empty($user) ? $user['username'] : '';
                // $emp['is_altlst']  = $this->_check_is_altlst($emp['department_id'], $emp['team_id']);
                // $emp['department'] = $this->config->item('department')[$emp['department_id']]['title'];
                // $emp['team']       = $this->SettingService->_team_detail($emp['team_id']);
            }

            return $profile;
        }

        public function _user_item_location($user_id){
            return $this->DatabaseModel->readArrayWithOptions(['user_id' => $user_id], 'id, location, isDefault', $this->TableService->ItemLocation);
        }

        public function _employee_by_location($locationName=null){
            $sql = 'SELECT 
                    Employee.user_id,
                    Employee.email, 
                    Employee.fullname, 
                    Employee.code_name 
                FROM Employee 
                LEFT JOIN ItemLocation ON ItemLocation.user_id = Employee.user_id
                WHERE ItemLocation.location = "'.$locationName.'"';
            return $this->DatabaseModel->readArrayQuery($sql);
        }

        private function _check_is_altlst($department_id, $team_id){
            # if this setting is exist, means this team is not ALT/LST
            $team_setting = $this->DatabaseModel->readOneWithOptions(['department_id' => $department_id, 'optteam_id' => $team_id, 'type_id' => 6
            ], $this->TableFieldService->SetTeam, $this->TableService->SetTeam);

            return !empty($team_setting) ? false : true;
        }

        public function _employee_full_detail($user_id){
            $employee = $this->_employee_detail($user_id);
            if(!empty($employee)){
                $employee['department'] = $this->config->item('department')[$employee['department_id']];
                $employee['team']       = $this->SettingService->_team_detail($employee['team_id']);
                $employee['type']       = $this->SettingService->_employment_type_detail($employee['employment_type_id']);
                $employee['shift']      = $this->_employee_shift_detail($user_id);
            }
            return $employee;
        }

        public function _employee_shift_detail($user_id){
            $employeeShifts = $this->DatabaseModel->readArrayWithOptions(['user_id' => $user_id], 'shift_id', $this->TableService->EmpShift);
            if(!empty($employeeShifts)){
                foreach ($employeeShifts as $k => $val) {
                    $employeeShift[$k] = $val;
                    $employeeShift[$k]['detail'] = $this->SettingService->_shift_detail($val['shift_id']);
                }
            }
            return isset($employeeShift) ? $employeeShift : [];
        }

        public function _addr_detail($ref_id=null, $ref=''){
            return $this->DatabaseModel->readOneWithOptions(['ref_id' => $ref_id, 'ref' => $ref], $this->TableFieldService->UserAddr, $this->TableService->UserAddr);
        }

        public function _full_addr($ref_id=null, $ref=''){
            $full_addr  = '';
            $addr       = $this->_addr_detail($ref_id, $ref);
            if(!empty($addr)){
                $postcode = $addr['postcode'] != 0 ? $addr['postcode'].' ' : '';
                $city = !empty($addr['city']) ? $addr['city'].' ' : '';
                $addrLine1  = !empty($addr['addr_line1']) ? $addr['addr_line1'].' ' : $addr['addr_line1'];
                $addrLine   = !empty($addr['addr_line2']) ? $addrLine1.$addr['addr_line2'].' ' : $addrLine1;
                $full_addr .= $addrLine.$postcode.$city.$addr['state'].' '.$addr['country'];
            }
            return $full_addr;
        }

        public function _all_user(){
            return $this->DatabaseModel->readArray($this->TableFieldService->User, $this->TableService->User);
        }

        public function _user_detail($user_id){
            $user = $this->DatabaseModel->readOneWithOptions(['id' => $user_id], $this->TableFieldService->User, $this->TableService->User);
            if(!empty($user)){
                $department   = [];
                $access_group = $this->DatabaseModel->readOneWithOptions(['id' => $user['group_id']
                ], $this->TableFieldService->AccessGrp, $this->TableService->AccessGrp);
                if(!empty($access_group)){
                    $department = $this->DatabaseModel->readOneWithOptions(['id' => $access_group['department_id']
                    ], $this->TableFieldService->Dept, $this->TableService->Dept);
                }
                $user['access_group']   = $access_group;
                $user['department']     = $department;
                if(isset($user['company_id'])){
                    $codename = $this->DatabaseModel->readOneWithOptions(['ref' => 'company', 'ref_id' => $user['company_id']
                    ], 'id', $this->TableService->CompanyCodeName);
                }
                $user['codename_id'] = isset($codename) ? $codename['id'] : null;
            }
            return $user;
        }

        public function _customer_listing(){
            return $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->Customer, 'code_name ASC', $this->TableService->Customer);
        }

        public function _employee_listing(){
            $employees = $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->Emp, 'fullname ASC', $this->TableService->Emp);
            return $this->_foreach_emp($employees);
        }

        public function _employee_listing_by_dep($department_id){
            $sql = '
                SELECT 
                    Employee.user_id,
                    Employee.fullname, 
                    Employee.code_name, 
                    User.group_id, 
                    AccessGroup.name AS access_group, 
                    AccessGroup.department_id, 
                    OptDepartment.title AS department_name
                FROM 
                    Employee
                LEFT JOIN 
                    User ON User.id = Employee.user_id
                LEFT JOIN
                    AccessGroup ON AccessGroup.id = User.group_id
                LEFT JOIN
                    OptDepartment ON OptDepartment.id = AccessGroup.department_id
                WHERE 
                    OptDepartment.id = '.$department_id.'
                ORDER BY
                    Employee.code_name ASC
            ';
            // $employees = $this->DatabaseModel->readArrayWithOptionsOrderBy(['department_id' => $department_id], $this->TableFieldService->Emp, 'fullname ASC', $this->TableService->Emp);
            $employees = $this->DatabaseModel->readArrayQuery($sql);
            // print_array($employees); exit();
            return $employees;
            // return $this->_foreach_emp($employees);
        }

        public function _employee_listing_by_team($team_id){
            $employees = $this->DatabaseModel->readArrayWithOptionsOrderBy(['team_id' => $team_id], $this->TableFieldService->Emp, 'fullname ASC', $this->TableService->Emp);
            if(!empty($employees)){
                foreach ($employees as $k => $val) {
                    $emp[$k] = $val;
                    $emp[$k]['acc']  = $this->_user_detail($val['user_id']);
                }
            }
            return isset($emp) ? $emp : [];
        }

        private function _foreach_emp($employees){
            if(!empty($employees)){
                foreach ($employees as $k => $val) {
                    $emp[$k] = $val;
                    $emp[$k]['acc']  = $this->_user_detail($val['user_id']);
                    $emp[$k]['team'] = $this->SettingService->_team_detail($val['team_id']);
                }
            }
            return isset($emp) ? $emp : [];
        }

        public function _all_employee_code_name(){
            return $this->DatabaseModel->readArray('code_name, user_id, id', $this->TableService->Emp);
        }

        public function _all_customer_code_name(){
            return $this->DatabaseModel->readArray('code_name', $this->TableService->Customer);
        }

        public function _customer_detail($customer_id){
            return $this->DatabaseModel->readOneWithOptions(['user_id' => $customer_id], $this->TableFieldService->Customer, $this->TableService->Customer);
        }

        public function _all_company_code_name(){
            $companyCodes = $this->DatabaseModel->readArrayOrderBy($this->TableFieldService->CompanyCodeName, 'code_name ASC', $this->TableService->CompanyCodeName);
            if(!empty($companyCodes)){
                foreach ($companyCodes as $k => $val) {
                    $companyCodes[$k]['company_name'] = $this->_get_company_name($val['ref'], $val['ref_id']);
                }
            }
            return $companyCodes;
        }

        public function _all_active_company_code_name(){
            $companyCodes = $this->DatabaseModel->readArrayWithOptionsOrderBy([
                'is_active' => 1
            ], $this->TableFieldService->CompanyCodeName, 'code_name ASC', $this->TableService->CompanyCodeName);
            if(!empty($companyCodes)){
                foreach ($companyCodes as $k => $val) {
                    $companyCodes[$k]['company_name'] = $this->_get_company_name($val['ref'], $val['ref_id']);
                }
            }
            return $companyCodes;
        }

        public function _get_company_name($ref, $ref_id){
            if($ref === 'company'){
                $company = $this->_company_detail($ref_id);
                return !empty($company) ? $company['company_name'] : null;
            } else {
                $branch = $this->_branch_detail($ref_id);
                return !empty($branch) ? $branch['branch_name'] : null;
            }
        }

        public function _user_type_by_company_id($company_id=null){
            return $this->DatabaseModel->readOneQuery('SELECT OptUserType.title FROM OptUserType
                LEFT JOIN Company ON Company.usertype_id = OptUserType.id
                WHERE Company.id = '.$company_id);
        }

    /**
     * CUSTOMER
     **/
     public function _all_customer(){
        return $this->_get_customers("WHERE CompanyCodeName.is_active = 1");
     }

     private function _get_customers($where=""){
        $sql = 'SELECT CompanyCodeName.*,
                Company.usertype_id,
                Company.company_name,
                CompanyBranch.branch_name,
                CompanyBranch.company_id
                FROM CompanyCodeName 
                LEFT JOIN Company ON Company.id = CompanyCodeName.ref_id AND CompanyCodeName.ref = "company" 
                LEFT JOIN CompanyBranch ON CompanyBranch.id = CompanyCodeName.ref_id AND CompanyCodeName.ref = "branch" '.$where.'
                ORDER BY CompanyCodeName.code_name ASC';
        $allActiveCompanyCodeName = $this->DatabaseModel->readArrayQuery($sql);
        $allCustomer = [];
        $allCompany  = array_filter($allActiveCompanyCodeName, function($row){
            return $row['ref'] === 'company' && $row['usertype_id'] == $this->config->item("user_type")["CUSTOMER"];
        });

        $allCompanyID = !empty($allCompany) ? array_column($allCompany, 'ref_id') : [];

        if(!empty($allActiveCompanyCodeName)){
            foreach ($allActiveCompanyCodeName as $k => $val) {
                if(in_array($val['ref_id'], $allCompanyID)){
                    $allCustomer[] = $val;
                }
                if(in_array($val['company_id'], $allCompanyID)){
                    $allCustomer[] = $val;
                }
            }
        }
        return $allCustomer;
     }

     public function _all_customer_include_nonactive(){
        return $this->_get_customers();
     }

    /**
     * SUPPLIER
     **/
     public function _all_supplier(){
        return $this->_get_suppliers("WHERE CompanyCodeName.is_active = 1");
     }
     public function _get_suppliers($where="", $limit=""){
        $sql = 'SELECT CompanyCodeName.*,
                Company.usertype_id,
                Company.company_name,
                CompanyBranch.branch_name,
                CompanyBranch.company_id
                FROM CompanyCodeName 
                LEFT JOIN Company ON Company.id = CompanyCodeName.ref_id AND CompanyCodeName.ref = "company" 
                LEFT JOIN CompanyBranch ON CompanyBranch.id = CompanyCodeName.ref_id AND CompanyCodeName.ref = "branch" '.$where.'
                ORDER BY CompanyCodeName.code_name ASC '.$limit;
        $allActiveCompanyCodeName = $this->DatabaseModel->readArrayQuery($sql);
        $allSupplier = [];
        $allCompany  = array_filter($allActiveCompanyCodeName, function($row){
            return $row['ref'] === 'company' && $row['usertype_id'] == $this->config->item("user_type")["SUPPLIER"];
        });

        // $allCompanyID = !empty($allCompany) ? array_column($allCompany, 'ref_id') : [];

        // if(!empty($allActiveCompanyCodeName)){
        //     foreach ($allActiveCompanyCodeName as $k => $val) {
        //         if(in_array($val['ref_id'], $allCompanyID)){
        //             $allSupplier[] = $val;
        //         }
        //         if(in_array($val['company_id'], $allCompanyID)){
        //             $allSupplier[] = $val;
        //         }
        //     }
        // }
        // return $allSupplier;
        return $allCompany;
     }

     public function _all_supplier_include_nonactive(){
        return $this->_get_suppliers();
     }

     public function _supplier_details($codename_id=null){
        $sql = 'SELECT CompanyCodeName.*,
                Company.usertype_id,
                Company.company_name,
                CompanyBranch.branch_name,
                CompanyBranch.company_id
                FROM CompanyCodeName 
                LEFT JOIN Company ON Company.id = CompanyCodeName.ref_id AND CompanyCodeName.ref = "company" 
                LEFT JOIN CompanyBranch ON CompanyBranch.id = CompanyCodeName.ref_id AND CompanyCodeName.ref = "branch" 
                WHERE CompanyCodeName.id = '.$codename_id;
        return $this->DatabaseModel->readOneQuery($sql);
     }
    
    /**
     * CUSTOMER & SUPPLIER
     **/
     public function _get_customer_suppliers_query($where="", $limit=""){
        $where = !empty($where) ? $where.' AND ' : ' WHERE';
        $where = $where.' CompanyCodeName.is_active = 1';
        $sql = 'SELECT CompanyCodeName.*,
                Company.usertype_id,
                Company.company_name,
                Company.acc_code,
                CompanyBranch.branch_name,
                CompanyBranch.company_id
                FROM CompanyCodeName 
                LEFT JOIN Company ON Company.id = CompanyCodeName.ref_id AND CompanyCodeName.ref = "company" 
                LEFT JOIN CompanyBranch ON CompanyBranch.id = CompanyCodeName.ref_id AND CompanyCodeName.ref = "branch" '.$where.'
                ORDER BY CompanyCodeName.code_name ASC '.$limit;
        return $sql;
     }

     public function _get_customer_suppliers($limit=""){
        $userType = $this->config->item('user_type');
        $where = 'WHERE Company.usertype_id IN('.$userType['CUSTOMER'].', '.$userType['SUPPLIER'].')';
        $sql = $this->_get_customer_suppliers_query($where, $limit);
        
        $allActiveCompanyCodeName = $this->DatabaseModel->readArrayQuery($sql);

        return $allActiveCompanyCodeName;
     }
}