<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class DutySettingService extends MY_Service {

    const _HOLS_NA          = 'na';
    const _HOLS_CUSTOM      = 'custom';
    const _HOLS_NATIONAL    = 'national';
    const _HOLS_REGIONAL    = 'regional';

    const _HOLS_TYPE = [
        'na'        => 'N/A',
        'custom'    => 'Smarter Holiday',
        'national'  => 'National Holiday',
        'regional'  => 'Regional Holiday'
    ];

	private $Services = [
        'hr/HrConfigService' 	=> 'HrConfigService',
        'UserService'           => 'UserService',
        'CalendarService'       => 'CalendarService',
        'SettingService'        => 'SettingService'
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);
    }

    public function _duty_config_listing($user_id){
        # to update - order by effective_date
        $configArr = $this->DatabaseModel->readArrayWithOptionsOrderBy(['user_id' => $user_id], $this->TableFieldService->DutyConfig, 'id ASC', $this->TableService->DutyConfig);

        if(!empty($configArr)){
            foreach ($configArr as $k => $val) {
                $config[$k] = $val;
                $config[$k]['calendar'] = $this->_duty_calendar_listing($val['id'], $val['setting_type']);
            }
        }

        return isset($config) ? $config : [];
    }

    public function _duty_calendar_detail_by_date($date){
        return $this->DatabaseModel->readOneWithOptions(['date' => $date], $this->TableFieldService->DutyCalendar, $this->TableService->DutyCalendar);
    }

    public function _duty_calendar_listing($dutyconfig_id, $setting_type){
        $calArr = $this->DatabaseModel->readArrayWithOptions(['dutyconfig_id' => $dutyconfig_id], $this->TableFieldService->DutyCalendar, $this->TableService->DutyCalendar);
        
        if(!empty($calArr)){
            foreach ($calArr as $k => $val) {
                $cal[$k] = $val;
                //$cal[$k]['ph'] = $this->CalendarService->_holiday_listing_by_date($val['date']);
                $cal[$k]['shift'] = $this->SettingService->_shift_detail($val['shift_id']);
                if($setting_type === 'day'){
                    $weekday = !empty($val['weekday']) ? json_decode($val['weekday']) : [];
                }
                $cal[$k]['working_days'] = isset($weekday) ? $weekday : [];
            }
        }

        return isset($cal) ? $cal : [];
    }

}