<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class OP_TaskStaffService extends MY_Service {
    private $data = array();

    protected $tblTask          = 'Task';
    protected $tblTaskAttnd     = 'TaskAttendance';
    protected $tblAssign        = 'TaskAssigned';
    protected $tblComment       = 'TaskComments';
    protected $tblUser          = 'User';
    protected $tblCustomer      = 'Customer';
    protected $tblEmployee      = 'Employee';
    protected $tblTeam          = 'OptTeam';
    protected $tblDepartment    = 'OptDepartment';

    private static $root        = 'operation/task/';
    private static $prefix_url  = 'operation/task';

    private $Services = [
        'task/ManagerService' => 'ManagerService',
        'task/OP_TaskDeleteService' => 'OP_TaskDeleteService',
    ];

    function __construct(){
        $this->data['root']      = self::$root;
        $this->data['prefixUrl'] = $this->prefixUrl = base_url(self::$prefix_url);
    }

    /* START :: MAIN */
        public function index(){
            $task_type = $this->input->get('type');
            if($task_type){
                if($task_type === 'today'){
                    $operator = '=';
                } else if($task_type === 'previous'){
                    $operator = '<';
                } else {
                    $operator = '>';
                }
            } else {
                $operator = '=';
            }

            $user_id = $this->session->userLogged['id'];

            $sql = 'SELECT id, cust_id, pc_no, title, description, createdby_id, planned_date, created_date, modified_date, status
                    FROM Task WHERE status != '.TaskService::_CLOSED.' AND planned_date '.$operator.' "'.getDateToday().'" ORDER BY planned_date ASC';

            $tasks      = $this->ManagerService->getTaskListing($this->DatabaseModel->readArrayQuery($sql));
            $customers  = $this->DatabaseModel->readArrayOrderBy('id, user_id, code_name', 'code_name ASC', $this->tblCustomer);

            if(!empty($tasks)){
                if($task_type === 'previous' || $this->uri->segment(3) === 'history'){
                    usort($tasks, function($a, $b){ return $a['planned_date'] < $b['planned_date']; });
                }
                foreach ($tasks as $k => $val) {
                    if(!empty($val['assigned'])){
                        foreach ($val['assigned'] as $k2 => $assigned) {
                            if($assigned['user_id'] == $user_id || $val['createdby_id'] == $user_id){
                                $task[] = $val;
                            }
                        }
                    }
                }
            }
            
            $this->data['task'] = isset($task) ? $task : null;
            $this->data['customers'] = $customers;
            $this->load->views(self::$root.'staff/list.tpl.php', $this->data);
        }

        public function getFilteredTask(){
            $customer_id = $this->input->post('customer_id');
            $title       = $this->input->post('title');
            $view        = $this->input->get('view');
            $task_type   = $this->input->post('task_type');

            $operator = !empty($view) ? '= ' : '!= ' ;

            if($task_type){
                if($task_type === 'today'){
                    $dateOperator = '=';
                } else if($task_type === 'previous'){
                    $dateOperator = '<';
                } else {
                    $dateOperator = '>';
                }
            } else {
                $dateOperator = '=';
            }

            $sql = 'SELECT id, cust_id, title, createdby_id, planned_date, created_date, modified_date, status FROM Task';
            $sql .= ' WHERE status '.$operator.TaskService::_CLOSED;

            if(!empty($customer_id) && empty($title)){
                $sql .= ' AND cust_id = '.$customer_id;
                if(empty($view)){
                    $sql .= ' AND planned_date '.$dateOperator.' "'.getDateToday().'"';
                }
            } 
            else if (empty($customer_id) && !empty($title)) {
                $sql .= ' AND title LIKE "%'.$title.'%"';
                if(empty($view)){
                    $sql .= ' AND planned_date '.$dateOperator.' "'.getDateToday().'"';
                }
            } 
            else if (empty($customer_id) && empty($title)){
                if(empty($view)){
                    $sql .= ' AND planned_date '.$dateOperator.' "'.getDateToday().'"';
                }
            }
            else {
                $sql .= ' AND cust_id = '.$customer_id.' AND title LIKE "%'.$title.'%"';
                if(empty($view)){
                    $sql .= ' AND planned_date '.$dateOperator.' "'.getDateToday().'"';
                }
            }

            $user_id = $this->session->userLogged['id'];
            $tasks   = $this->DatabaseModel->readArrayQuery($sql);

            if(!empty($tasks)){
                if($task_type === 'previous' || !empty($view)){
                    usort($tasks, function($a, $b){ return $a['planned_date'] < $b['planned_date']; });
                }
                foreach ($tasks as $k => $val) {
                    $assigned = $this->DatabaseModel->readOneWithOptions(['task_id' => $val['id'], 'user_id' => $user_id], 'id', $this->tblAssign);
                    if(!empty($assigned) || $val['createdby_id'] == $user_id){
                        $filtered_task[] = $val;
                    }
                }
            }

            if(isset($filtered_task)){
                $task = $this->ManagerService->getTaskListing($filtered_task);
            }
            
            $this->data['task'] = isset($task) ? $task : null;
            $this->load->view(self::$root.'staff/ajax/ajx-task-list.tpl.php', $this->data);
        }

        public function history(){
            $sql = 'SELECT id, cust_id, pc_no, title, description, createdby_id, planned_date, created_date, modified_date, status
                    FROM Task WHERE status = '.ManagerService::_CLOSED.' ORDER BY GREATEST(created_date, modified_date)';

            $tasks = $this->DatabaseModel->readArrayQuery($sql);
            $task  = $this->ManagerService->getTaskListing($tasks);
            
            $this->data['task'] = $task;
            $this->load->views(self::$root.'staff/list.tpl.php', $this->data);
        }

    /* START :: VIEW */
        public function view($task_id){
            $user_id        = $this->session->userLogged['id'];
            $hasSignedIn    = $this->ManagerService->checkHasSignedIn($task_id, $user_id);
            $task           = $this->ManagerService->getTaskDetail($task_id);
            $assigned       = $this->DatabaseModel->readOneWithOptions(['task_id' => $task_id, 'user_id' => $user_id], 'id', $this->tblAssign);
            $canStartTask   = false;

            if(!empty($task)){
                if($task['createdby_id'] == $user_id){
                    if(!empty($assigned)){
                        $canStartTask = true;
                    }
                } else {
                    if(!empty($assigned)){
                        $canStartTask = true;
                    }
                }
            }

            $taskAttnd      = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id
            ], 'id, user_id, check_in, check_out, date', 'date DESC', $this->tblTaskAttnd);

            $comments       = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id
            ], 'id, jobsheet_type, commentby_id, comment_type, comment, created_date, modified_date, is_edited', 'created_date ASC', $this->tblComment);
            //$department = $this->DatabaseModel->readArrayOrderBy('id, title, code_name', 'title ASC', $this->tblDepartment);

            if(!empty($taskAttnd)){
                foreach ($taskAttnd as $k => $val) {
                    $attnd[$k] = $val;
                    $attnd[$k]['employee'] = $this->ManagerService->getEmployeeDetail($val['user_id']);
                }
            }

            $user = $this->ManagerService->ManagerService->getEmployeeDetail($user_id);
            if(!empty($user)){
                $user['department'] = $this->ManagerService->getDepartmentDetail($user['department_id']);
                $team = $this->ManagerService->getTeams($user['department_id']);
            }

            if(!empty($comments)){
                foreach ($comments as $k => $val) {
                    $comment[$k] = $val;
                    $comment[$k]['employee'] = $this->ManagerService->getEmployeeDetail($val['commentby_id']);
                }
            }

            if(!empty($hasSignedIn)){
                if(!isEmptyTimestamp($hasSignedIn['check_in'])){
                    $hasCheckedIn = true;
                } else {
                    $hasCheckedIn = false;
                }
            } else {
                $hasCheckedIn = false;
            }

            $this->viewTaskActions($task_id, $user_id);

            $this->data['task']             = $task;
            $this->data['user']             = $user;
            $this->data['attnd']            = isset($attnd) ? $attnd : null;
            $this->data['comment']          = isset($comment) ? $comment : null;
            //$this->data['department']     = $department;
            $this->data['team']             = isset($team) ? $team : null;
            $this->data['hasSignedIn']      = $hasSignedIn;
            $this->data['hasCheckedIn']     = $hasCheckedIn;
            $this->data['canStartTask']    = $canStartTask;
            $this->load->views(self::$root.'staff/view.tpl.php', $this->data);
        }

        private function viewTaskActions($task_id, $user_id){
            if(isset($_POST['complete'])){
                $this->DatabaseModel->updateData(['id' => $task_id], [
                    'modifiedby_id' => $user_id,
                    'modified_date' => getCurrentTimeStamp(),
                    'status'        => TaskService::_COMPLETED
                ], $this->tblTask);

                $this->session->set_flashdata('success_msg', updateMsg());
                redirect(current_url());
            }

            if(isset($_POST['progress'])){
                $this->DatabaseModel->updateData(['id' => $task_id], [
                    'modifiedby_id' => $user_id,
                    'modified_date' => getCurrentTimeStamp(),
                    'status'        => TaskService::_INPROGRESS
                ], $this->tblTask);

                $this->session->set_flashdata('success_msg', updateMsg());
                redirect(current_url());
            }

            if(isset($_POST['close'])){
                $this->DatabaseModel->updateData(['id' => $task_id], [
                    'modifiedby_id' => $user_id,
                    'modified_date' => getCurrentTimeStamp(),
                    'status'        => TaskService::_CLOSED
                ], $this->tblTask);

                $this->session->set_flashdata('success_msg', updateMsg());
                redirect($this->prefixUrl.'/history/view/'.$task_id);
            }

            if(isset($_POST['submit_comment'])){
                $this->form_validation->set_rules('comment', 'Comment', 'trim|required');

                if($this->form_validation->run() == true){
                    $this->DatabaseModel->createData([
                        'task_id'       => $task_id,
                        'commentby_id'  => $user_id,
                        'comment_type'  => $this->input->post('comment_type'),
                        'comment'       => $this->input->post('comment'),
                        'created_date'  => getCurrentTimeStamp()
                    ], $this->tblComment);

                    $this->session->set_flashdata('success_msg', updateMsg());
                    redirect($this->input->post('tab_url'));
                }
            }

            if(isset($_POST['update_comment'])){
                $this->form_validation->set_rules('comment', 'Comment', 'trim|required');

                if($this->form_validation->run() == true){
                    $this->DatabaseModel->updateData(['id' => $this->input->post('comment_id')], [
                        'comment'       => $this->input->post('comment'),
                        'modified_date' => getCurrentTimeStamp(),
                        'is_edited'     => 1
                    ], $this->tblComment);

                    $this->session->set_flashdata('success_msg', updateMsg());
                    redirect($this->input->post('url'));
                }
            }

            if(isset($_POST['clear_all_comment'])){
                $comment_type = $this->input->post('comment_type');
                $this->DatabaseModel->deleteData(['task_id' => $task_id, 'comment_type' => $comment_type], $this->tblComment);
                $this->session->set_flashdata('success_msg', deleteMsg());
                redirect($this->input->post('tab_url'));
            }

            if(isset($_POST['delete_comment'])){
                print_array($this->input->post()); exit();
            }
        }

        public function view_history($task_id){
            $task       = $this->ManagerService->getTaskDetail($task_id);
            $comments   = $this->DatabaseModel->readArrayWithOptionsOrderBy(['task_id' => $task_id
            ], 'id, commentby_id, comment_type, comment, created_date, modified_date, is_edited', 'created_date ASC', $this->tblComment);

            if(!empty($comments)){
                foreach ($comments as $k => $val) {
                    $comment[$k] = $val;
                    $comment[$k]['employee'] = $this->ManagerService->getEmployeeDetail($val['commentby_id']);
                }
            }

            if(isset($_POST['open'])){
                $this->DatabaseModel->updateData(['id' => $task_id], [
                    'modifiedby_id' => $this->session->userLogged['id'],
                    'modified_date' => getCurrentTimeStamp(),
                    'status'        => TaskService::_OPEN
                ], $this->tblTask);

                $this->session->set_flashdata('success_msg', updateMsg());
                redirect($this->prefixUrl.'/view/'.$task_id);
            }

            $this->data['task']     = $task;
            $this->data['comment']  = isset($comment) ? $comment : null;
            $this->data['is_staff'] = true;
            $this->load->views(self::$root.'manager/view-history.tpl.php', $this->data);
        }

    /* START :: CREATE */
        /*public function create(){
            $customer = $this->DatabaseModel->readArray('user_id, company_name, code_name', $this->tblCustomer);
            $this->data['customer'] = $customer;
            $this->load->views(self::$root.'manager/create.tpl.php', $this->data);
        }

        public function createTask(){
            $this->form_validation
                ->set_rules('cust_id', 'Customer Name', 'trim|required')
                ->set_rules('pc_no', 'PC No / System ID', 'trim|required')
                ->set_rules('title', 'Title', 'trim|required')
                ->set_rules('description', 'Description', 'trim|required')
                ->set_rules('planned_date', 'Plan Date', 'trim|required');

            if($this->form_validation->run() == true){
                $taskData = [
                    'cust_id'       => $this->input->post('cust_id'),
                    'pc_no'         => $this->input->post('pc_no'),
                    'title'         => $this->input->post('title'),
                    'description'   => $this->input->post('description'),
                    'createdby_id'  => $this->session->userLogged['id'],
                    'planned_date'  => date('Y-m-d', strtotime($this->input->post('planned_date'))),
                    'created_date'  => getCurrentTimeStamp()
                ];

                $this->DatabaseModel->createData($taskData, $this->tblTask);
                echo json_encode(['status' => true, 'redirect' => $this->prefixUrl]);
            } else {
                $this->FormService->returnFormError($this->form_validation->error_array());
            }
        }*/
}