<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class CommentService extends MY_Service {
    const _SERVICE  = 0;
    const _HARDWARE = 1;    // is the ITEM, previously called HARDWARE

    const _JS_SUBMIT_VERIFY  = 1;
    const _JS_MANAGER_VERIFY = 2;
    const _JS_ADMIN_VERIFY   = 3;
    const _JS_ACC_VERIFY     = 4;

    private $data = array();
    private static $file_view = '';

    private $Services = [
        'task/ManagerService' => 'ManagerService',
        'task/StaffService'   => 'StaffService',
        'task/SettingService' => 'SettingService'
    ];

	function __construct(){
        parent::__construct();
        $this->load->service($this->Services);

        if($this->session->userLogged['department_id'] == UserService::DEP_HR){
            self::$file_view = 'default/hr/task/default/comments/';
        } else {
            self::$file_view = 'default/operation/task/default/comments/';
        }
    }

    public function displayCommentTabContent($comment, $tab, $tab_url, $comment_type){
    	$this->data['comment'] 		= $comment;
    	$this->data['tab'] 			= $tab;
    	$this->data['tab_url'] 		= $tab_url;
    	$this->data['comment_type'] = $comment_type;
    	$this->load->view(self::$file_view.'open-comments/comment-tab-content.tpl.php', $this->data);
    }

    public function displayClosedCommentTabContent($comment, $tab, $tab_url, $comment_type){
        $this->data['comment']      = $comment;
        $this->data['tab']          = $tab;
        $this->data['tab_url']      = $tab_url;
        $this->data['comment_type'] = $comment_type;
        $this->load->view(self::$file_view.'closed-comments/comment.tpl.php', $this->data);
    }

    public function isPermitted($permit_type=null, $commentby_id){
        if($permit_type === 'task_type'){
            if($this->session->userLogged['role_id'] == UserService::_STAFF){
                if($this->session->userLogged['id'] == $commentby_id){
                    return null;
                } else {
                    return 'disabled';
                }
            } else {
                return null;
            }
        }
    }

    public function notifyMsg($msg_type){
        if($msg_type === 'verify'){
            return 'You have to start task in order to verify jobsheet.';
        }
        if($msg_type === 'comment'){
            return 'You have to start task in order to write a new comment or verify jobsheet.';
        }
    }

    public function verifiedMsg(){
        return 'This jobsheet has been verified.';
    }

    public function _get_team_setting(){
        $department_id = $this->session->userLogged['department_id'];
        $team_id       = $this->session->userLogged['team_id'];
        $isPermitted   = FALSE;

        if($this->session->userLogged['role_id'] == UserService::_STAFF){
            if($department_id == UserService::DEP_OPERATION){
                $SettingTeam = $this->DatabaseModel->readOneWithOptions([
                    'department_id' => $department_id, 
                    'optteam_id'    => $team_id,
                    'type_id'       => SettingService::_OP_SET_ALTLST_COMMENT
                ], 'id', $this->TableService->SetTeam);

                $isPermitted = !empty($SettingTeam) ? TRUE : FALSE;
            }
        } else {
            $isPermitted = TRUE;
        }

        return $isPermitted;
    }

    public function _is_internal_permitted(){
        $department_id = $this->session->userLogged['department_id'];
        $team_id       = $this->session->userLogged['team_id'];
        $isPermitted   = FALSE;

        if($this->session->userLogged['role_id'] == UserService::_STAFF){
            if($department_id == UserService::DEP_OPERATION){
                $SettingTeam = $this->DatabaseModel->readOneWithOptions([
                    'department_id' => $department_id, 
                    'optteam_id'    => $team_id,
                    'type_id'       => SettingService::_OP_SET_ALTLST_COMMENT
                ], 'id', $this->TableService->SetTeam);

                $isPermitted = !empty($SettingTeam) ? FALSE : TRUE;
            }
        } else {
            $isPermitted = TRUE;
        }

        return $isPermitted;
    }

    public function updateChargeType($comment_id){
        echo $comment_id;
    }

}